/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.org.apache.commons.pool.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.openmdx.uses.org.apache.commons.pool.BaseKeyedObjectPool;
import org.openmdx.uses.org.apache.commons.pool.KeyedObjectPool;
import org.openmdx.uses.org.apache.commons.pool.KeyedPoolableObjectFactory;

public class StackKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected HashMap _pools = null;
    protected KeyedPoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _initSleepingCapacity = 4;
    protected int _totActive = 0;
    protected int _totIdle = 0;
    protected HashMap _activeCount = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(int max) {
        this(null, max, 4);
    }

    public StackKeyedObjectPool(int max, int init) {
        this(null, max, init);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory factory) {
        this(factory, 8);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory factory, int max) {
        this(factory, max, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory factory, int max, int init) {
        this._factory = factory;
        this._maxSleeping = max < 0 ? 8 : max;
        this._initSleepingCapacity = init < 1 ? 4 : init;
        this._pools = new HashMap();
        this._activeCount = new HashMap();
    }

    @Override
    public synchronized Object borrowObject(Object key) throws Exception {
        Object obj = null;
        Stack stack = (Stack)this._pools.get(key);
        if (null == stack) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(key, stack);
        }
        try {
            obj = stack.pop();
            --this._totIdle;
        }
        catch (Exception e) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            obj = this._factory.makeObject(key);
        }
        if (null != obj && null != this._factory) {
            this._factory.activateObject(key, obj);
        }
        this.incrementActiveCount(key);
        return obj;
    }

    @Override
    public synchronized void returnObject(Object key, Object obj) throws Exception {
        this.decrementActiveCount(key);
        if (null == this._factory || this._factory.validateObject(key, obj)) {
            Stack<Object> stack = (Stack<Object>)this._pools.get(key);
            if (null == stack) {
                stack = new Stack<Object>();
                stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
                this._pools.put(key, stack);
            }
            if (null != this._factory) {
                try {
                    this._factory.passivateObject(key, obj);
                }
                catch (Exception e) {
                    this._factory.destroyObject(key, obj);
                    return;
                }
            }
            if (stack.size() < this._maxSleeping) {
                stack.push(obj);
                ++this._totIdle;
            } else if (null != this._factory) {
                this._factory.destroyObject(key, obj);
            }
        } else if (null != this._factory) {
            this._factory.destroyObject(key, obj);
        }
    }

    @Override
    public synchronized void invalidateObject(Object key, Object obj) throws Exception {
        this.decrementActiveCount(key);
        if (null != this._factory) {
            this._factory.destroyObject(key, obj);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObject(Object key) throws Exception {
        Object obj = this._factory.makeObject(key);
        StackKeyedObjectPool stackKeyedObjectPool = this;
        synchronized (stackKeyedObjectPool) {
            this.incrementActiveCount(key);
            this.returnObject(key, obj);
        }
    }

    @Override
    public int getNumIdle() {
        return this._totIdle;
    }

    @Override
    public int getNumActive() {
        return this._totActive;
    }

    @Override
    public int getNumActive(Object key) {
        return this.getActiveCount(key);
    }

    @Override
    public synchronized int getNumIdle(Object key) {
        try {
            return ((Stack)this._pools.get(key)).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public synchronized void clear() {
        for (Object key : this._pools.keySet()) {
            Stack stack = (Stack)this._pools.get(key);
            this.destroyStack(key, stack);
        }
        this._totIdle = 0;
        this._pools.clear();
        this._activeCount.clear();
    }

    @Override
    public synchronized void clear(Object key) {
        Stack stack = (Stack)this._pools.remove(key);
        this.destroyStack(key, stack);
    }

    private synchronized void destroyStack(Object key, Stack stack) {
        if (null == stack) {
            return;
        }
        if (null != this._factory) {
            Enumeration e = stack.elements();
            while (e.hasMoreElements()) {
                try {
                    this._factory.destroyObject(key, e.nextElement());
                }
                catch (Exception exception) {}
            }
        }
        this._totIdle -= stack.size();
        this._activeCount.remove(key);
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" contains ").append(this._pools.size()).append(" distinct pools: ");
        for (Object key : this._pools.keySet()) {
            buf.append(" |").append(key).append("|=");
            Stack s = (Stack)this._pools.get(key);
            buf.append(s.size());
        }
        return buf.toString();
    }

    @Override
    public synchronized void close() throws Exception {
        this.clear();
        this._pools = null;
        this._factory = null;
        this._activeCount = null;
    }

    @Override
    public synchronized void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    private int getActiveCount(Object key) {
        try {
            return (Integer)this._activeCount.get(key);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    private void incrementActiveCount(Object key) {
        ++this._totActive;
        Integer old = (Integer)this._activeCount.get(key);
        if (null == old) {
            this._activeCount.put(key, new Integer(1));
        } else {
            this._activeCount.put(key, new Integer(old + 1));
        }
    }

    private void decrementActiveCount(Object key) {
        --this._totActive;
        Integer active = (Integer)this._activeCount.get(key);
        if (null != active) {
            if (active <= 1) {
                this._activeCount.remove(key);
            } else {
                this._activeCount.put(key, new Integer(active - 1));
            }
        }
    }
}

