/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openmdx.uses.org.apache.commons.pool.BaseObjectPool;
import org.openmdx.uses.org.apache.commons.pool.ObjectPool;
import org.openmdx.uses.org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool
extends BaseObjectPool
implements ObjectPool {
    private List _pool = new ArrayList();
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;

    public SoftReferenceObjectPool() {
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory factory) {
        this._factory = factory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory factory, int initSize) throws Exception {
        this._factory = factory;
        if (null != this._factory) {
            for (int i = 0; i < initSize; ++i) {
                Object obj = this._factory.makeObject();
                this._factory.passivateObject(obj);
                this._pool.add(new SoftReference<Object>(obj));
            }
        }
    }

    @Override
    public synchronized Object borrowObject() throws Exception {
        this.assertOpen();
        Object obj = null;
        while (null == obj) {
            if (this._pool.isEmpty()) {
                if (null == this._factory) {
                    throw new NoSuchElementException();
                }
                obj = this._factory.makeObject();
                continue;
            }
            SoftReference ref = (SoftReference)this._pool.remove(this._pool.size() - 1);
            obj = ref.get();
        }
        if (null != this._factory && null != obj) {
            this._factory.activateObject(obj);
        }
        ++this._numActive;
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object obj) throws Exception {
        this.assertOpen();
        boolean success = true;
        if (!this._factory.validateObject(obj)) {
            success = false;
        } else {
            try {
                this._factory.passivateObject(obj);
            }
            catch (Exception e) {
                success = false;
            }
        }
        boolean shouldDestroy = !success;
        SoftReferenceObjectPool softReferenceObjectPool = this;
        synchronized (softReferenceObjectPool) {
            --this._numActive;
            if (success) {
                this._pool.add(new SoftReference<Object>(obj));
            }
            this.notifyAll();
        }
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void invalidateObject(Object obj) throws Exception {
        this.assertOpen();
        --this._numActive;
        this._factory.destroyObject(obj);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObject() throws Exception {
        Object obj = this._factory.makeObject();
        SoftReferenceObjectPool softReferenceObjectPool = this;
        synchronized (softReferenceObjectPool) {
            ++this._numActive;
            this.returnObject(obj);
        }
    }

    @Override
    public int getNumIdle() {
        return this._pool.size();
    }

    @Override
    public int getNumActive() {
        return this._numActive;
    }

    @Override
    public synchronized void clear() {
        this.assertOpen();
        if (null != this._factory) {
            Iterator iter = this._pool.iterator();
            while (iter.hasNext()) {
                try {
                    Object obj = ((SoftReference)iter.next()).get();
                    if (null == obj) continue;
                    this._factory.destroyObject(obj);
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    @Override
    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        super.close();
    }

    @Override
    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

