/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient.packets;

import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusPacket;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.UserPasswordAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;

public class PapAccessRequest
extends RadiusPacket {
    private boolean initialized = false;

    public PapAccessRequest(String userName, String plaintextPassword) throws InvalidParameterException {
        this(userName, plaintextPassword.getBytes());
    }

    public PapAccessRequest(String userName, byte[] plaintextPassword) throws InvalidParameterException {
        super(1);
        this.setAttribute(new UserNameAttribute(userName));
        this.setAttribute(new UserPasswordAttribute(plaintextPassword));
        this.initialized = true;
    }

    @Override
    public void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (this.initialized && radiusAttribute.getType() == 1) {
            throw new InvalidParameterException("Already initialized, cannot reset username.");
        }
    }
}

