/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient.packets;

import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusPacket;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.AcctSessionIdAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.AcctStatusTypeAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.ServiceTypeAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;

public class AccountingRequest
extends RadiusPacket {
    public static final byte[] START_ACCOUNTING_SERVICE_TYPE = new byte[]{0, 0, 0, 1};
    public static final byte[] STOP_ACCOUNTING_SERVICE_TYPE = new byte[]{0, 0, 0, 2};
    public static final byte[] UPDATE_ACCOUNTING_SERVICE_TYPE = new byte[]{0, 0, 0, 3};
    public static final byte[] ENABLE_ACCOUNTING_SERVICE_TYPE = new byte[]{0, 0, 0, 7};
    public static final byte[] DISABLE_ACCOUNTING_SERVICE_TYPE = new byte[]{0, 0, 0, 8};
    private boolean initialized = false;

    public AccountingRequest(String userName, byte[] serviceType, String sessionId) throws InvalidParameterException {
        super(4);
        this.setAttribute(new UserNameAttribute(userName));
        this.setAttribute(new ServiceTypeAttribute(serviceType));
        this.setAttribute(new AcctStatusTypeAttribute(serviceType));
        this.setAttribute(new AcctSessionIdAttribute(sessionId.getBytes()));
        this.initialized = true;
    }

    @Override
    public void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (this.initialized && (radiusAttribute.getType() == 1 || radiusAttribute.getType() == 6 || radiusAttribute.getType() == 40 || radiusAttribute.getType() == 44)) {
            throw new InvalidParameterException("Already initialized, cannot reset USER_NAME, SERVICE_TYPE, ACCT_STATUS_TYPE or ACCT_SESSION_ID.");
        }
        if (radiusAttribute.getType() == 6 && radiusAttribute.getValue().length != 4) {
            throw new InvalidParameterException("SERVICE_TYPE must be 4 bytes long.");
        }
    }
}

