/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient.jaas;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusClient;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusPacket;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.RadiusException;
import org.openmdx.uses.net.sourceforge.jradiusclient.jaas.RadiusCallback;
import org.openmdx.uses.net.sourceforge.jradiusclient.jaas.RadiusPrincipal;
import org.openmdx.uses.net.sourceforge.jradiusclient.packets.PapAccessRequest;

public class RadiusLoginModule
implements LoginModule {
    public static final int MAX_CHALLENGE_ATTEMPTS = 3;
    protected Subject radiusSubject;
    protected CallbackHandler callbackHandler;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> moduleOptions;
    private boolean authenticationSucceeded = false;
    private boolean authenticationCommitted = false;
    private String userName;
    private RadiusPrincipal userPrincipal;
    private int challengedAttempts = 0;
    private RadiusClient radiusClient;

    @Override
    public boolean abort() throws LoginException {
        if (!this.authenticationSucceeded) {
            return false;
        }
        if (this.authenticationSucceeded && !this.authenticationCommitted) {
            this.authenticationSucceeded = false;
            this.userName = null;
            this.radiusClient = null;
            this.userPrincipal = null;
            this.challengedAttempts = 0;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticationSucceeded) {
            return false;
        }
        this.userPrincipal = new RadiusPrincipal(this.userName);
        if (!this.radiusSubject.getPrincipals().contains(this.userPrincipal)) {
            this.radiusSubject.getPrincipals().add(this.userPrincipal);
        }
        this.userName = null;
        this.radiusClient = null;
        this.challengedAttempts = 0;
        this.authenticationCommitted = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.radiusSubject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.moduleOptions = options;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: No callback handler installed to gather username and password.");
        }
        NameCallback nameCallback = new NameCallback("User Name: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", true);
        RadiusCallback radiusCallback = new RadiusCallback();
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback, radiusCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioex) {
            throw new LoginException(ioex.getMessage());
        }
        catch (UnsupportedCallbackException uscbex) {
            StringBuffer sb = new StringBuffer("Error: callback ");
            sb.append(uscbex.getCallback().toString());
            sb.append(" not supported.");
            throw new LoginException(sb.toString());
        }
        this.userName = nameCallback.getName();
        char[] userPassword = passwordCallback.getPassword();
        if (userPassword == null) {
            userPassword = new char[]{};
        }
        passwordCallback.clearPassword();
        try {
            this.radiusClient = new RadiusClient(radiusCallback.getHostName(), radiusCallback.getAuthPort(), radiusCallback.getAcctPort(), radiusCallback.getSharedSecret());
            PapAccessRequest accessRequest = new PapAccessRequest(this.userName, String.valueOf(userPassword));
            this.authenticate(accessRequest, radiusCallback.getNumRetries());
        }
        catch (InvalidParameterException ivpex) {
            StringBuffer sb1 = new StringBuffer("Configuration of the RADIUS client is incorrect. ");
            sb1.append(ivpex.getMessage());
            throw new LoginException(sb1.toString());
        }
        catch (RadiusException rex) {
            StringBuffer sb2 = new StringBuffer("Configuration of the RADIUS client is incorrect. ");
            sb2.append(rex.getMessage());
            throw new LoginException(sb2.toString());
        }
        for (int i = 0; i < userPassword.length; ++i) {
            userPassword[i] = 32;
        }
        userPassword = null;
        this.authenticationSucceeded = true;
        return true;
    }

    private void authenticate(RadiusPacket accessRequest, int numRetries) throws LoginException {
        try {
            RadiusPacket accessResponse = this.radiusClient.authenticate(accessRequest, numRetries);
            switch (accessResponse.getPacketType()) {
                case 2: {
                    break;
                }
                case 3: {
                    throw new CredentialExpiredException("Incorrect User Name or Password.");
                }
                case 11: {
                    if (this.challengedAttempts > 3) {
                        this.challengedAttempts = 0;
                        throw new LoginException("Maximum number of challenge retries exceeded.");
                    }
                    Callback[] callbacks = new Callback[1];
                    String password = null;
                    callbacks[0] = new PasswordCallback(String.valueOf(accessResponse.getAttribute(18).getValue()), true);
                    try {
                        this.callbackHandler.handle(callbacks);
                        password = String.valueOf(((PasswordCallback)callbacks[0]).getPassword());
                        if (password == null) {
                            password = new String("");
                        }
                        ((PasswordCallback)callbacks[0]).clearPassword();
                    }
                    catch (IOException ioex) {
                        throw new LoginException(ioex.getMessage());
                    }
                    catch (UnsupportedCallbackException uscbex) {
                        StringBuffer sb = new StringBuffer("Error: callback ");
                        sb.append(uscbex.getCallback().toString());
                        sb.append(" not supported.");
                        throw new LoginException(sb.toString());
                    }
                    ++this.challengedAttempts;
                    PapAccessRequest challengeResponse = new PapAccessRequest(this.userName, String.valueOf(password));
                    this.authenticate(challengeResponse, 1);
                    break;
                }
                default: {
                    throw new LoginException("Received an Invalid response from the RADIUS Server.");
                }
            }
        }
        catch (InvalidParameterException ivpex) {
            throw new LoginException(ivpex.getMessage());
        }
        catch (RadiusException rex) {
            throw new LoginException(rex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.radiusSubject.getPrincipals().remove(this.userPrincipal);
        this.authenticationCommitted = false;
        this.authenticationSucceeded = false;
        this.userName = null;
        this.radiusClient = null;
        this.userPrincipal = null;
        this.challengedAttempts = 0;
        return true;
    }
}

