/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.uses.net.sourceforge.jradiusclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;

public class RadiusAttribute {
    private static final int HEADER_LENGTH = 2;
    private byte[] packetBytes;

    public RadiusAttribute(int type, byte[] value) throws InvalidParameterException {
        if (type > 256) {
            throw new InvalidParameterException("type must be small enough to fit in a byte (i.e. less than 256) and should be chosen from static final constants defined in RadiusValues");
        }
        if (null == value) {
            throw new InvalidParameterException("Value cannot be NULL");
        }
        int length = 2 + value.length;
        try (ByteArrayOutputStream temp = new ByteArrayOutputStream(length);){
            temp.write(type);
            temp.write(length);
            temp.write(value);
            temp.flush();
            this.packetBytes = temp.toByteArray();
        }
        catch (IOException ioex) {
            throw new InvalidParameterException("Error constructing RadiusAttribute");
        }
    }

    public int getType() {
        return this.packetBytes[0];
    }

    public byte[] getValue() {
        int valueLength = this.packetBytes.length - 2;
        byte[] valueBytes = new byte[valueLength];
        System.arraycopy(this.packetBytes, 2, valueBytes, 0, valueLength);
        return valueBytes;
    }

    protected final byte[] getBytes() {
        return this.packetBytes;
    }
}

