/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.resource.radius.client;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.logging.ClassicFormatter;
import org.openmdx.resource.radius.client.ConnectionFactory;
import org.openmdx.resource.radius.client.ManagedConnection;
import org.openmdx.resource.spi.AbstractManagedConnectionFactory;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusClient;
import org.openmdx.uses.net.sourceforge.jradiusclient.RadiusConnection;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.InvalidParameterException;
import org.openmdx.uses.net.sourceforge.jradiusclient.exception.RadiusException;

public class ManagedConnectionFactory
extends AbstractManagedConnectionFactory {
    private static final long serialVersionUID = 6915930278489524854L;
    private final boolean logToAdapter;
    private final Logger logger;
    private String[] hosts;
    private int[] authenticationPorts;
    private int[] accountingPorts;
    private BigDecimal socketTimeout = null;
    private InetAddress nasAddress = null;
    private boolean trace = false;

    protected ManagedConnectionFactory(Logger logger) {
        this.logToAdapter = logger == null;
        if (this.logToAdapter) {
            this.logger = Logger.getLogger(ManagedConnectionFactory.class.getName());
            this.logger.addHandler(new LogHandler());
        } else {
            this.logger = logger;
        }
    }

    public ManagedConnectionFactory() {
        this(null);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setLogWriter(PrintWriter logWriter) {
        super.setLogWriter(logWriter);
        if (this.logToAdapter) {
            this.logger.setUseParentHandlers(logWriter == null);
        }
    }

    public void setConnectionURL(String connectionURL) {
        super.setConnectionURL(connectionURL);
        String[] urls = connectionURL.split("\\s+");
        this.hosts = new String[urls.length];
        this.authenticationPorts = new int[urls.length];
        this.accountingPorts = new int[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                String url = urls[i];
                int s = url.indexOf(59);
                URI uri = new URI(s < 0 ? url : url.substring(0, s));
                this.hosts[i] = uri.getHost();
                int port = uri.getPort();
                this.authenticationPorts[i] = port < 0 ? 1812 : port;
                this.accountingPorts[i] = 1813;
                continue;
            }
            catch (URISyntaxException exception) {
                throw (IllegalArgumentException)BasicException.initHolder((Throwable)new IllegalArgumentException("Invalid RADIUS connection URL configuration. The expected syntax is a blank separated list of \u00abaaa://\u2039radius-host\u203a:\u2039authentication-port\u203a;transport=udp;protocol=radius\u00bb entries.", (Throwable)BasicException.newEmbeddedExceptionStack((Throwable)exception, (String)"DefaultDomain", (int)-32, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("index", i), new BasicException.Parameter("url", (Object)urls[i])})));
            }
        }
    }

    public String getSocketTimeout() {
        return this.socketTimeout == null ? null : this.socketTimeout.toString();
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout == null ? null : new BigDecimal(socketTimeout);
    }

    public String getNasAddress() {
        return this.nasAddress.getHostAddress();
    }

    public void setNasAddress(String nasAddress) {
        try {
            this.nasAddress = InetAddress.getByName(nasAddress);
        }
        catch (UnknownHostException exception) {
            throw (IllegalArgumentException)BasicException.initHolder((Throwable)new IllegalArgumentException("Invalid Address", (Throwable)BasicException.newEmbeddedExceptionStack((Throwable)exception, (String)"DefaultDomain", (int)-32, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("nasAddress", (Object)nasAddress)})));
        }
    }

    public org.openmdx.resource.cci.ConnectionFactory<RadiusConnection, RadiusException> createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new ConnectionFactory(this, connectionManager);
    }

    public org.openmdx.resource.cci.ConnectionFactory<RadiusConnection, RadiusException> createConnectionFactory() throws ResourceException {
        return (org.openmdx.resource.cci.ConnectionFactory)super.createConnectionFactory();
    }

    protected ManagedConnection newManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential credential = this.getPasswordCredential(subject);
        try {
            return new ManagedConnection(this, credential, new RadiusClient(this.hosts, this.authenticationPorts, this.accountingPorts, credential == null ? this.getPassword() : new String(credential.getPassword()), this.socketTimeout, this.logger, this.trace, this.nasAddress));
        }
        catch (RadiusException exception) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException("RADIUS client could not be created", (Throwable)BasicException.newEmbeddedExceptionStack((Throwable)exception, (String)"DefaultDomain", (int)-25, (BasicException.Parameter[])new BasicException.Parameter[0])));
        }
        catch (InvalidParameterException exception) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Invalid RADIUS client configuration", (Throwable)BasicException.newEmbeddedExceptionStack((Throwable)exception, (String)"DefaultDomain", (int)-32, (BasicException.Parameter[])new BasicException.Parameter[0])));
        }
    }

    public boolean equals(Object that) {
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }

    class LogHandler
    extends Handler {
        LogHandler() {
            if (super.getFormatter() == null) {
                super.setFormatter((Formatter)new ClassicFormatter());
            }
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
            PrintWriter logWriter = ManagedConnectionFactory.this.getLogWriter();
            if (logWriter != null) {
                logWriter.flush();
            }
        }

        @Override
        public void publish(LogRecord record) {
            PrintWriter logWriter = ManagedConnectionFactory.this.getLogWriter();
            if (logWriter != null) {
                logWriter.println(this.getFormatter().format(record));
            }
        }
    }
}

