/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.text.parsing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.ietf.jgss.Oid;
import org.openmdx.kernel.text.parsing.AbstractParser;
import org.openmdx.kernel.text.spi.Parser;

public class StandardPrimitiveTypeParser
extends AbstractParser {
    private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Boolean.class, String.class, Byte.class, Short.class, Integer.class, Long.class, BigDecimal.class, BigInteger.class, URI.class, Oid.class);
    private static final Parser INSTANCE = new StandardPrimitiveTypeParser();

    private StandardPrimitiveTypeParser() {
    }

    public static Parser getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean handles(Class<?> type) {
        return SUPPORTED_TYPES.contains(type);
    }

    @Override
    protected Object parseAs(String externalRepresentation, Class<?> valueClass) throws Exception {
        return valueClass == Byte.class ? Byte.valueOf(externalRepresentation) : (valueClass == Long.class ? Long.valueOf(externalRepresentation) : (valueClass == Integer.class ? Integer.valueOf(externalRepresentation) : (valueClass == Short.class ? Short.valueOf(externalRepresentation) : (valueClass == String.class ? externalRepresentation : (valueClass == Boolean.class ? Boolean.valueOf(externalRepresentation) : (valueClass == BigDecimal.class ? new BigDecimal(externalRepresentation) : (valueClass == BigInteger.class ? new BigInteger(externalRepresentation) : (valueClass == URI.class ? new URI(externalRepresentation) : (valueClass == Oid.class ? new Oid(externalRepresentation) : super.parseAs(externalRepresentation, valueClass))))))))));
    }
}

