/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.text.format;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import javax.resource.cci.Record;
import org.openmdx.kernel.collection.ArraysExtension;
import org.openmdx.kernel.text.MultiLineStringRepresentation;
import org.openmdx.kernel.text.format.HexadecimalFormatter;

public class IndentingFormatter
implements MultiLineStringRepresentation {
    private final Object source;

    public IndentingFormatter(Object source) {
        this.source = source;
    }

    public String toString() {
        return IndentingFormatter.toString(this.source);
    }

    public static String toString(Object source) {
        return IndentingFormatter.appendObject(new StringBuilder(), source).toString();
    }

    protected static CharSequence appendObject(StringBuilder target, Object source) {
        if (source == null) {
            target.append("null");
        } else if (source instanceof Record) {
            IndentingFormatter.appendHeader(target, (Record)source);
            if (source instanceof List) {
                IndentingFormatter.appendList(target, (List)source);
            } else if (source instanceof Map) {
                IndentingFormatter.appendMap(target, (Map)source);
            } else {
                target.append(source.getClass().getName()).append('@').append(System.identityHashCode(source));
            }
        } else if (source instanceof List) {
            IndentingFormatter.appendList(target, (List)source);
        } else if (source instanceof Map) {
            IndentingFormatter.appendMap(target, (Map)source);
        } else if (source instanceof byte[]) {
            target.append(new HexadecimalFormatter((byte[])source));
        } else if (source.getClass().isArray()) {
            IndentingFormatter.appendList(target, ArraysExtension.asList(source));
        } else {
            target.append(source);
        }
        return target;
    }

    protected static void appendHeader(StringBuilder target, Record source) {
        String recordName = source.getRecordName();
        String recordShortDescription = source.getRecordShortDescription();
        if (recordName != null) {
            target.append(recordName);
            if (recordShortDescription != null) {
                target.append(" (").append(recordShortDescription).append(')');
            }
            target.append(": ");
        } else if (recordShortDescription != null) {
            target.append('(').append(recordShortDescription).append("): ");
        }
    }

    protected static void appendEntry(StringBuilder target, String key, String separator, Object value) {
        int j = target.append("\n\t").length();
        target.append(key).append(separator);
        if (value instanceof String) {
            target.append('\"').append(value).append('\"');
        } else if (value instanceof Character) {
            target.append('\'').append(value).append('\'');
        } else {
            IndentingFormatter.appendObject(target, value);
        }
        while (j < target.length()) {
            if (target.charAt(j++) != '\n') continue;
            target.insert(j++, '\t');
        }
    }

    protected static void appendList(StringBuilder target, List<?> source) {
        target.append('[');
        String terminator = "]";
        ListIterator<?> i = source.listIterator();
        while (i.hasNext()) {
            IndentingFormatter.appendEntry(target, String.valueOf(i.nextIndex()), ": ", i.next());
            terminator = "\n]";
        }
        target.append(terminator);
    }

    protected static void appendMap(StringBuilder target, Map<?, ?> source) {
        target.append('{');
        String terminator = "}";
        TreeMap ordered = new TreeMap();
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            ordered.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : ordered.entrySet()) {
            IndentingFormatter.appendEntry(target, (String)entry.getKey(), " = ", entry.getValue());
            terminator = "\n}";
        }
        target.append(terminator);
    }
}

