/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.collection;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.openmdx.kernel.collection.InternalizedKeys;

public class InternalizedKeyMap<K, V>
extends AbstractMap<K, V> {
    private final IdentityHashMap<K, V> delegate;

    public InternalizedKeyMap() {
        this.delegate = new IdentityHashMap();
    }

    public InternalizedKeyMap(int expectedMaxSize) {
        this.delegate = new IdentityHashMap(expectedMaxSize);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return InternalizedKeys.isInternalizable(key) && this.delegate.containsKey(InternalizedKeys.internalize(key));
    }

    @Override
    public V get(Object key) {
        return InternalizedKeys.isInternalizable(key) ? (V)this.delegate.get(InternalizedKeys.internalize(key)) : null;
    }

    @Override
    public V put(K key, V value) {
        K internalizedKey = InternalizedKeys.internalize(key);
        return this.delegate.put(internalizedKey, value);
    }

    @Override
    public V remove(Object key) {
        return InternalizedKeys.isInternalizable(key) ? (V)this.delegate.remove(InternalizedKeys.internalize(key)) : null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

