/*
 * Decompiled with CFR 0.152.
 */
package org.openmdx.kernel.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openmdx.base.resource.cci.Freezable;
import org.openmdx.kernel.collection.InternalizedKeys;

public class ArraysExtension {
    private ArraysExtension() {
    }

    public static <V> List<V> asList(Object array) {
        return new AsList(array);
    }

    public static <K, V> Map<K, V> asMap(Object[] keys, Object[] values) {
        return new AsMap(keys, values);
    }

    static Object clone(Object original) {
        int length = Array.getLength(original);
        Object copy = Array.newInstance(original.getClass().getComponentType(), Array.getLength(original));
        System.arraycopy(original, 0, copy, 0, length);
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        return Arrays.copyOf(original, newLength);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays.copyOf(original, newLength, original.getClass());
    }

    public static class AsMap
    extends AbstractMap
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 3202169295074577277L;
        Object[] keys;
        Object[] values;
        private transient List<?> valueList = null;
        private transient boolean keysAreNormalized = false;

        protected AsMap(Object[] keys, Object[] values) {
            this.keys = keys;
            this.normalizeKeys();
            this.values = values;
        }

        protected void normalizeKeys() {
            if (!this.keysAreNormalized) {
                int i;
                boolean normalizeKeys = false;
                for (i = 0; i < this.keys.length; ++i) {
                    if (this.keys[i] == InternalizedKeys.internalize(this.keys[i])) continue;
                    normalizeKeys = true;
                    break;
                }
                if (normalizeKeys) {
                    for (i = 0; i < this.keys.length; ++i) {
                        this.keys[i] = InternalizedKeys.internalize(this.keys[i]);
                    }
                }
                this.keysAreNormalized = true;
            }
        }

        protected AsMap() {
        }

        @Override
        public Set entrySet() {
            return new EntrySet();
        }

        private int slotOf(Object rawKey) {
            this.normalizeKeys();
            Object key = InternalizedKeys.internalize(rawKey);
            int iLimit = this.size();
            for (int index = 0; index < iLimit; ++index) {
                if (this.keys[index] != key) continue;
                return index;
            }
            return -1;
        }

        @Override
        public Object get(Object key) {
            int slot = this.slotOf(key);
            return slot == -1 || slot >= this.values.length ? null : this.values[slot];
        }

        @Override
        public Object put(Object key, Object value) {
            int slot = this.slotOf(key);
            if (slot == -1) {
                throw new IllegalArgumentException("This key value is not among the fixed set of keys");
            }
            Object oldValue = this.values[slot];
            this.values[slot] = value;
            return oldValue;
        }

        @Override
        public int size() {
            return this.keys.length;
        }

        @Override
        public Collection values() {
            if (this.valueList == null) {
                this.valueList = new AsList(this.values);
            }
            return this.valueList;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.slotOf(key) >= 0;
        }

        @Override
        public boolean containsValue(Object object) {
            int vLimit = this.values.length;
            if (vLimit < this.size() && object == null) {
                return true;
            }
            for (int index = 0; index < vLimit; ++index) {
                if (!AsMap.areEqual(this.values[index], object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        protected static boolean areEqual(Object left, Object right) {
            return left == null ? right == null : left.equals(right);
        }

        protected static int hashCode(Object object) {
            return object == null ? 0 : object.hashCode();
        }

        @Override
        public Object clone() {
            return new AsMap((Object[])ArraysExtension.clone(this.keys), (Object[])ArraysExtension.clone(this.values));
        }

        private final class MapEntry
        implements Map.Entry {
            private final int slot;

            MapEntry(int slot) {
                this.slot = slot;
            }

            public Object getKey() {
                return AsMap.this.keys[this.slot];
            }

            public Object getValue() {
                return this.slot < AsMap.this.values.length ? AsMap.this.values[this.slot] : null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object other) {
                if (!(other instanceof Map.Entry)) return false;
                Map.Entry that = (Map.Entry)other;
                if (!AsMap.areEqual(this.getKey(), that.getKey())) return false;
                if (!AsMap.areEqual(this.getValue(), that.getValue())) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return AsMap.hashCode(this.getKey()) ^ AsMap.hashCode(this.getValue());
            }

            public Object setValue(Object value) {
                Object result = this.getValue();
                AsMap.this.values[this.slot] = value;
                return result;
            }

            public String toString() {
                return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
            }
        }

        final class EntryIterator
        implements Iterator {
            int index = 0;

            EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < AsMap.this.size();
            }

            public Map.Entry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new MapEntry(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        class EntrySet
        extends AbstractSet {
            EntrySet() {
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return AsMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AsMap.this.isEmpty();
            }
        }
    }

    public static class AsList
    extends AbstractList
    implements Cloneable,
    Serializable,
    Freezable {
        private static final long serialVersionUID = 3258134669471267120L;
        private boolean immutable;
        private Object array;
        private int size;

        protected AsList(Object array, int size) {
            this.array = array;
            this.size = size;
        }

        protected AsList(Object array) {
            this(array, Array.getLength(array));
        }

        protected AsList() {
        }

        protected Object getDelegate() {
            return this.array;
        }

        @Override
        public Object get(int index) {
            return index < this.size ? Array.get(this.array, index) : null;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object set(int index, Object element) {
            if (this.immutable) {
                throw new UnsupportedOperationException("Modification is no longer supported as soon as the colloction is made immutable");
            }
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index " + index + " exceeds the size " + this.size);
            }
            Object result = this.get(index);
            Array.set(this.array, index, element);
            return result;
        }

        public Object clone() {
            return new AsList(ArraysExtension.clone(this.array), this.size);
        }

        public void makeImmutable() {
            this.immutable = true;
        }

        public boolean isImmutable() {
            return this.immutable;
        }
    }
}

