/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.spark.api.io.neo4j;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.rules.TemporaryFolder;
import org.opencypher.okapi.api.io.PropertyGraphDataSource;
import org.opencypher.okapi.api.io.conversion.NodeMapping;
import org.opencypher.okapi.api.io.conversion.RelationshipMapping;
import org.opencypher.okapi.api.schema.Schema;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.ir.api.expr.Expr;
import org.opencypher.okapi.relational.api.graph.RelationalCypherGraph;
import org.opencypher.okapi.testing.BaseTestSuite;
import org.opencypher.spark.api.CAPSSession;
import org.opencypher.spark.api.io.CAPSNodeTable;
import org.opencypher.spark.api.io.CAPSRelationshipTable;
import org.opencypher.spark.api.io.neo4j.Neo4jBulkCSVDataSink;
import org.opencypher.spark.api.io.neo4j.Neo4jBulkCSVDataSink$;
import org.opencypher.spark.impl.acceptance.ScanGraphInit;
import org.opencypher.spark.impl.acceptance.ScanGraphInit$class;
import org.opencypher.spark.impl.table.SparkTable;
import org.opencypher.spark.testing.CAPSTestSuite;
import org.opencypher.spark.testing.fixture.SparkSessionFixture;
import org.opencypher.spark.testing.fixture.TeamDataFixture;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\tAb*Z85U\n+Hn[\"T-\u0012\u000bG/Y*j].$Vm\u001d;\u000b\u0005\r!\u0011!\u00028f_RR'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003)y\u0007/\u001a8dsBDWM\u001d\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\f\u001dIA\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003C\u0001\bi\u0016\u001cH/\u001b8h\u0013\t)\"CA\u0007D\u0003B\u001bF+Z:u'VLG/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033I\tqAZ5yiV\u0014X-\u0003\u0002\u001c1\tyA+Z1n\t\u0006$\u0018MR5yiV\u0014X\r\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005Q\u0011mY2faR\fgnY3\u000b\u0005\u0005B\u0011\u0001B5na2L!a\t\u0010\u0003\u001bM\u001b\u0017M\\$sCBD\u0017J\\5u!\t)\u0003&D\u0001'\u0015\t9C\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011F\n\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0003\u0011\u001d\u0001\u0004A1A\u0005\u0012E\nq\u0001^3na\u0012K'/F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003sk2,7O\u0003\u00028\u0019\u0005)!.\u001e8ji&\u0011\u0011\b\u000e\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"11\b\u0001Q\u0001\nI\n\u0001\u0002^3na\u0012K'\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003%9'/\u00199i\u001d\u0006lW-F\u0001@!\t\u0001e)D\u0001B\u0015\t\u00115)A\u0003he\u0006\u0004\bN\u0003\u0002\b\t*\u0011QIC\u0001\u0006_.\f\u0007/[\u0005\u0003\u000f\u0006\u0013\u0011b\u0012:ba\"t\u0015-\\3\t\r%\u0003\u0001\u0015!\u0003@\u0003)9'/\u00199i\u001d\u0006lW\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0003%q\u0017-\\3ta\u0006\u001cW-F\u0001N!\t\u0001e*\u0003\u0002P\u0003\nIa*Y7fgB\f7-\u001a\u0005\u0007#\u0002\u0001\u000b\u0011B'\u0002\u00159\fW.Z:qC\u000e,\u0007\u0005C\u0003T\u0001\u0011EC+A\u0005cK\u001a|'/Z!mYR\tQ\u000b\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0003V]&$\b\"\u0002/\u0001\t#\"\u0016\u0001C1gi\u0016\u0014\u0018\t\u001c7\t\u000by\u0003A\u0011B0\u0002\u0005\u0011\u001cX#\u00011\u0011\u00059\n\u0017B\u00012\u0003\u0005QqUm\u001c\u001bk\u0005Vd7nQ*W\t\u0006$\u0018mU5oW\u0002")
public class Neo4jBulkCSVDataSinkTest
extends CAPSTestSuite
implements TeamDataFixture,
ScanGraphInit {
    private final TemporaryFolder tempDir;
    private final String org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName;
    private final String namespace;
    private final Expr n;
    private final Expr nHasLabelGerman;
    private final Expr nHasLabelBook;
    private final Expr nHasLabelPerson;
    private final Expr nHasLabelProgrammer;
    private final Expr nHasLabelSwedish;
    private final Expr nHasLabelBrogrammer;
    private final Expr nHasPropertyLanguage;
    private final Expr nHasPropertyLuckyNumber;
    private final Expr nHasPropertyTitle;
    private final Expr nHasPropertyYear;
    private final Expr nHasPropertyName;
    private final Expr r;
    private final Expr rStart;
    private final Expr rEnd;
    private final Expr rHasTypeKnows;
    private final Expr rHasTypeReads;
    private final Expr rHasTypeInfluences;
    private final Expr rHasPropertyRecommends;
    private final Expr rHasPropertySince;
    private final String dataFixture;
    private final Schema dataFixtureSchema;
    private final int nbrNodes;
    private final Map<Map<String, CypherValue.CypherValue>, Object> teamDataGraphNodes;
    private final Map<Map<String, CypherValue.CypherValue>, Object> teamDataGraphRels;
    private final Set<Object> csvTestGraphTags;
    private final Map<Row, Object> csvTestGraphNodes;
    private final Map<Row, Object> csvTestGraphRels;
    private final Map<Row, Object> csvTestGraphRelsFromRecords;
    private final String dataFixtureWithoutArrays;
    private final Map<Row, Object> csvTestGraphNodesWithoutArrays;
    private final Map<Row, Object> csvTestGraphRelsWithoutArrays;
    private final NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping;
    private final Dataset<Row> personDF;
    private final CAPSNodeTable personTable;
    private final RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping;
    private final Dataset<Row> knowsDF;
    private final CAPSRelationshipTable knowsTable;
    private final NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping;
    private final Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF;
    private final CAPSNodeTable programmerTable;
    private final NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping;
    private final Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF;
    private final CAPSNodeTable brogrammerTable;
    private final NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping;
    private final Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF;
    private final CAPSNodeTable bookTable;
    private final RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping;
    private final Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF;
    private final CAPSRelationshipTable readsTable;
    private final RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping;
    private final Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF;
    private final CAPSRelationshipTable influencesTable;
    private volatile long bitmap$0;

    @Override
    public RelationalCypherGraph<SparkTable.DataFrameTable> initGraph(String createQuery, CAPSSession caps) {
        return ScanGraphInit$class.initGraph(this, createQuery, caps);
    }

    public Expr n() {
        return this.n;
    }

    public Expr nHasLabelGerman() {
        return this.nHasLabelGerman;
    }

    public Expr nHasLabelBook() {
        return this.nHasLabelBook;
    }

    public Expr nHasLabelPerson() {
        return this.nHasLabelPerson;
    }

    public Expr nHasLabelProgrammer() {
        return this.nHasLabelProgrammer;
    }

    public Expr nHasLabelSwedish() {
        return this.nHasLabelSwedish;
    }

    public Expr nHasLabelBrogrammer() {
        return this.nHasLabelBrogrammer;
    }

    public Expr nHasPropertyLanguage() {
        return this.nHasPropertyLanguage;
    }

    public Expr nHasPropertyLuckyNumber() {
        return this.nHasPropertyLuckyNumber;
    }

    public Expr nHasPropertyTitle() {
        return this.nHasPropertyTitle;
    }

    public Expr nHasPropertyYear() {
        return this.nHasPropertyYear;
    }

    public Expr nHasPropertyName() {
        return this.nHasPropertyName;
    }

    public Expr r() {
        return this.r;
    }

    public Expr rStart() {
        return this.rStart;
    }

    public Expr rEnd() {
        return this.rEnd;
    }

    public Expr rHasTypeKnows() {
        return this.rHasTypeKnows;
    }

    public Expr rHasTypeReads() {
        return this.rHasTypeReads;
    }

    public Expr rHasTypeInfluences() {
        return this.rHasTypeInfluences;
    }

    public Expr rHasPropertyRecommends() {
        return this.rHasPropertyRecommends;
    }

    public Expr rHasPropertySince() {
        return this.rHasPropertySince;
    }

    private String dataFixture$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 1L) == 0L) {
                this.dataFixture = TeamDataFixture.class.dataFixture((TeamDataFixture)this);
                this.bitmap$0 |= 1L;
            }
            return this.dataFixture;
        }
    }

    public String dataFixture() {
        return (this.bitmap$0 & 1L) == 0L ? this.dataFixture$lzycompute() : this.dataFixture;
    }

    private Schema dataFixtureSchema$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 2L) == 0L) {
                this.dataFixtureSchema = TeamDataFixture.class.dataFixtureSchema((TeamDataFixture)this);
                this.bitmap$0 |= 2L;
            }
            return this.dataFixtureSchema;
        }
    }

    public Schema dataFixtureSchema() {
        return (this.bitmap$0 & 2L) == 0L ? this.dataFixtureSchema$lzycompute() : this.dataFixtureSchema;
    }

    private int nbrNodes$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 4L) == 0L) {
                this.nbrNodes = TeamDataFixture.class.nbrNodes((TeamDataFixture)this);
                this.bitmap$0 |= 4L;
            }
            return this.nbrNodes;
        }
    }

    public int nbrNodes() {
        return (this.bitmap$0 & 4L) == 0L ? this.nbrNodes$lzycompute() : this.nbrNodes;
    }

    private Map teamDataGraphNodes$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 8L) == 0L) {
                this.teamDataGraphNodes = TeamDataFixture.class.teamDataGraphNodes((TeamDataFixture)this);
                this.bitmap$0 |= 8L;
            }
            return this.teamDataGraphNodes;
        }
    }

    public Map<Map<String, CypherValue.CypherValue>, Object> teamDataGraphNodes() {
        return (this.bitmap$0 & 8L) == 0L ? this.teamDataGraphNodes$lzycompute() : this.teamDataGraphNodes;
    }

    private Map teamDataGraphRels$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x10L) == 0L) {
                this.teamDataGraphRels = TeamDataFixture.class.teamDataGraphRels((TeamDataFixture)this);
                this.bitmap$0 |= 0x10L;
            }
            return this.teamDataGraphRels;
        }
    }

    public Map<Map<String, CypherValue.CypherValue>, Object> teamDataGraphRels() {
        return (this.bitmap$0 & 0x10L) == 0L ? this.teamDataGraphRels$lzycompute() : this.teamDataGraphRels;
    }

    private Set csvTestGraphTags$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x20L) == 0L) {
                this.csvTestGraphTags = TeamDataFixture.class.csvTestGraphTags((TeamDataFixture)this);
                this.bitmap$0 |= 0x20L;
            }
            return this.csvTestGraphTags;
        }
    }

    public Set<Object> csvTestGraphTags() {
        return (this.bitmap$0 & 0x20L) == 0L ? this.csvTestGraphTags$lzycompute() : this.csvTestGraphTags;
    }

    private Map csvTestGraphNodes$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x40L) == 0L) {
                this.csvTestGraphNodes = TeamDataFixture.class.csvTestGraphNodes((TeamDataFixture)this);
                this.bitmap$0 |= 0x40L;
            }
            return this.csvTestGraphNodes;
        }
    }

    public Map<Row, Object> csvTestGraphNodes() {
        return (this.bitmap$0 & 0x40L) == 0L ? this.csvTestGraphNodes$lzycompute() : this.csvTestGraphNodes;
    }

    private Map csvTestGraphRels$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x80L) == 0L) {
                this.csvTestGraphRels = TeamDataFixture.class.csvTestGraphRels((TeamDataFixture)this);
                this.bitmap$0 |= 0x80L;
            }
            return this.csvTestGraphRels;
        }
    }

    public Map<Row, Object> csvTestGraphRels() {
        return (this.bitmap$0 & 0x80L) == 0L ? this.csvTestGraphRels$lzycompute() : this.csvTestGraphRels;
    }

    private Map csvTestGraphRelsFromRecords$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x100L) == 0L) {
                this.csvTestGraphRelsFromRecords = TeamDataFixture.class.csvTestGraphRelsFromRecords((TeamDataFixture)this);
                this.bitmap$0 |= 0x100L;
            }
            return this.csvTestGraphRelsFromRecords;
        }
    }

    public Map<Row, Object> csvTestGraphRelsFromRecords() {
        return (this.bitmap$0 & 0x100L) == 0L ? this.csvTestGraphRelsFromRecords$lzycompute() : this.csvTestGraphRelsFromRecords;
    }

    private String dataFixtureWithoutArrays$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x200L) == 0L) {
                this.dataFixtureWithoutArrays = TeamDataFixture.class.dataFixtureWithoutArrays((TeamDataFixture)this);
                this.bitmap$0 |= 0x200L;
            }
            return this.dataFixtureWithoutArrays;
        }
    }

    public String dataFixtureWithoutArrays() {
        return (this.bitmap$0 & 0x200L) == 0L ? this.dataFixtureWithoutArrays$lzycompute() : this.dataFixtureWithoutArrays;
    }

    private Map csvTestGraphNodesWithoutArrays$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x400L) == 0L) {
                this.csvTestGraphNodesWithoutArrays = TeamDataFixture.class.csvTestGraphNodesWithoutArrays((TeamDataFixture)this);
                this.bitmap$0 |= 0x400L;
            }
            return this.csvTestGraphNodesWithoutArrays;
        }
    }

    public Map<Row, Object> csvTestGraphNodesWithoutArrays() {
        return (this.bitmap$0 & 0x400L) == 0L ? this.csvTestGraphNodesWithoutArrays$lzycompute() : this.csvTestGraphNodesWithoutArrays;
    }

    private Map csvTestGraphRelsWithoutArrays$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x800L) == 0L) {
                this.csvTestGraphRelsWithoutArrays = TeamDataFixture.class.csvTestGraphRelsWithoutArrays((TeamDataFixture)this);
                this.bitmap$0 |= 0x800L;
            }
            return this.csvTestGraphRelsWithoutArrays;
        }
    }

    public Map<Row, Object> csvTestGraphRelsWithoutArrays() {
        return (this.bitmap$0 & 0x800L) == 0L ? this.csvTestGraphRelsWithoutArrays$lzycompute() : this.csvTestGraphRelsWithoutArrays;
    }

    private NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x1000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x1000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping;
        }
    }

    public NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping() {
        return (this.bitmap$0 & 0x1000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$personMapping;
    }

    private Dataset personDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x2000L) == 0L) {
                this.personDF = TeamDataFixture.class.personDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x2000L;
            }
            return this.personDF;
        }
    }

    public Dataset<Row> personDF() {
        return (this.bitmap$0 & 0x2000L) == 0L ? this.personDF$lzycompute() : this.personDF;
    }

    private CAPSNodeTable personTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x4000L) == 0L) {
                this.personTable = TeamDataFixture.class.personTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x4000L;
            }
            return this.personTable;
        }
    }

    public CAPSNodeTable personTable() {
        return (this.bitmap$0 & 0x4000L) == 0L ? this.personTable$lzycompute() : this.personTable;
    }

    private RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x8000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x8000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping;
        }
    }

    public RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping() {
        return (this.bitmap$0 & 0x8000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$knowsMapping;
    }

    private Dataset knowsDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x10000L) == 0L) {
                this.knowsDF = TeamDataFixture.class.knowsDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x10000L;
            }
            return this.knowsDF;
        }
    }

    public Dataset<Row> knowsDF() {
        return (this.bitmap$0 & 0x10000L) == 0L ? this.knowsDF$lzycompute() : this.knowsDF;
    }

    private CAPSRelationshipTable knowsTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x20000L) == 0L) {
                this.knowsTable = TeamDataFixture.class.knowsTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x20000L;
            }
            return this.knowsTable;
        }
    }

    public CAPSRelationshipTable knowsTable() {
        return (this.bitmap$0 & 0x20000L) == 0L ? this.knowsTable$lzycompute() : this.knowsTable;
    }

    private NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x40000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x40000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping;
        }
    }

    public NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping() {
        return (this.bitmap$0 & 0x40000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerMapping;
    }

    private Dataset org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x80000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x80000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF;
        }
    }

    public Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF() {
        return (this.bitmap$0 & 0x80000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$programmerDF;
    }

    private CAPSNodeTable programmerTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x100000L) == 0L) {
                this.programmerTable = TeamDataFixture.class.programmerTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x100000L;
            }
            return this.programmerTable;
        }
    }

    public CAPSNodeTable programmerTable() {
        return (this.bitmap$0 & 0x100000L) == 0L ? this.programmerTable$lzycompute() : this.programmerTable;
    }

    private NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x200000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x200000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping;
        }
    }

    public NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping() {
        return (this.bitmap$0 & 0x200000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerMapping;
    }

    private Dataset org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x400000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x400000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF;
        }
    }

    public Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF() {
        return (this.bitmap$0 & 0x400000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$brogrammerDF;
    }

    private CAPSNodeTable brogrammerTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x800000L) == 0L) {
                this.brogrammerTable = TeamDataFixture.class.brogrammerTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x800000L;
            }
            return this.brogrammerTable;
        }
    }

    public CAPSNodeTable brogrammerTable() {
        return (this.bitmap$0 & 0x800000L) == 0L ? this.brogrammerTable$lzycompute() : this.brogrammerTable;
    }

    private NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x1000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x1000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping;
        }
    }

    public NodeMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping() {
        return (this.bitmap$0 & 0x1000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookMapping;
    }

    private Dataset org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x2000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x2000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF;
        }
    }

    public Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF() {
        return (this.bitmap$0 & 0x2000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$bookDF;
    }

    private CAPSNodeTable bookTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x4000000L) == 0L) {
                this.bookTable = TeamDataFixture.class.bookTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x4000000L;
            }
            return this.bookTable;
        }
    }

    public CAPSNodeTable bookTable() {
        return (this.bitmap$0 & 0x4000000L) == 0L ? this.bookTable$lzycompute() : this.bookTable;
    }

    private RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x8000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x8000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping;
        }
    }

    public RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping() {
        return (this.bitmap$0 & 0x8000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsMapping;
    }

    private Dataset org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x10000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x10000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF;
        }
    }

    public Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF() {
        return (this.bitmap$0 & 0x10000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$readsDF;
    }

    private CAPSRelationshipTable readsTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x20000000L) == 0L) {
                this.readsTable = TeamDataFixture.class.readsTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x20000000L;
            }
            return this.readsTable;
        }
    }

    public CAPSRelationshipTable readsTable() {
        return (this.bitmap$0 & 0x20000000L) == 0L ? this.readsTable$lzycompute() : this.readsTable;
    }

    private RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x40000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping((TeamDataFixture)this);
                this.bitmap$0 |= 0x40000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping;
        }
    }

    public RelationshipMapping org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping() {
        return (this.bitmap$0 & 0x40000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesMapping;
    }

    private Dataset org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x80000000L) == 0L) {
                this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF = TeamDataFixture.class.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF((TeamDataFixture)this);
                this.bitmap$0 |= 0x80000000L;
            }
            return this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF;
        }
    }

    public Dataset<Row> org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF() {
        return (this.bitmap$0 & 0x80000000L) == 0L ? this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF$lzycompute() : this.org$opencypher$spark$testing$fixture$TeamDataFixture$$influencesDF;
    }

    private CAPSRelationshipTable influencesTable$lzycompute() {
        Neo4jBulkCSVDataSinkTest neo4jBulkCSVDataSinkTest = this;
        synchronized (neo4jBulkCSVDataSinkTest) {
            if ((this.bitmap$0 & 0x100000000L) == 0L) {
                this.influencesTable = TeamDataFixture.class.influencesTable((TeamDataFixture)this);
                this.bitmap$0 |= 0x100000000L;
            }
            return this.influencesTable;
        }
    }

    public CAPSRelationshipTable influencesTable() {
        return (this.bitmap$0 & 0x100000000L) == 0L ? this.influencesTable$lzycompute() : this.influencesTable;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$n_$eq(Expr x$1) {
        this.n = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelGerman_$eq(Expr x$1) {
        this.nHasLabelGerman = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelBook_$eq(Expr x$1) {
        this.nHasLabelBook = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelPerson_$eq(Expr x$1) {
        this.nHasLabelPerson = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelProgrammer_$eq(Expr x$1) {
        this.nHasLabelProgrammer = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelSwedish_$eq(Expr x$1) {
        this.nHasLabelSwedish = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasLabelBrogrammer_$eq(Expr x$1) {
        this.nHasLabelBrogrammer = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasPropertyLanguage_$eq(Expr x$1) {
        this.nHasPropertyLanguage = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasPropertyLuckyNumber_$eq(Expr x$1) {
        this.nHasPropertyLuckyNumber = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasPropertyTitle_$eq(Expr x$1) {
        this.nHasPropertyTitle = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasPropertyYear_$eq(Expr x$1) {
        this.nHasPropertyYear = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$nHasPropertyName_$eq(Expr x$1) {
        this.nHasPropertyName = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$r_$eq(Expr x$1) {
        this.r = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rStart_$eq(Expr x$1) {
        this.rStart = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rEnd_$eq(Expr x$1) {
        this.rEnd = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rHasTypeKnows_$eq(Expr x$1) {
        this.rHasTypeKnows = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rHasTypeReads_$eq(Expr x$1) {
        this.rHasTypeReads = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rHasTypeInfluences_$eq(Expr x$1) {
        this.rHasTypeInfluences = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rHasPropertyRecommends_$eq(Expr x$1) {
        this.rHasPropertyRecommends = x$1;
    }

    public void org$opencypher$spark$testing$fixture$TeamDataFixture$_setter_$rHasPropertySince_$eq(Expr x$1) {
        this.rHasPropertySince = x$1;
    }

    public int nbrRels() {
        return TeamDataFixture.class.nbrRels((TeamDataFixture)this);
    }

    public TemporaryFolder tempDir() {
        return this.tempDir;
    }

    public String org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName() {
        return this.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName;
    }

    private String namespace() {
        return this.namespace;
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
        this.tempDir().create();
        RelationalCypherGraph<SparkTable.DataFrameTable> graph = this.initGraph(this.dataFixture(), this.caps());
        Neo4jBulkCSVDataSink dataSource = new Neo4jBulkCSVDataSink(this.tempDir().getRoot().getAbsolutePath(), Neo4jBulkCSVDataSink$.MODULE$.$lessinit$greater$default$2(), this.caps());
        dataSource.store(this.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), graph);
        this.caps().catalog().register(this.namespace(), (PropertyGraphDataSource)dataSource);
    }

    public void afterAll() {
        this.tempDir().delete();
        SparkSessionFixture.class.afterAll((BaseTestSuite)this);
    }

    public Neo4jBulkCSVDataSink org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds() {
        return (Neo4jBulkCSVDataSink)this.caps().catalog().source(this.namespace());
    }

    public Neo4jBulkCSVDataSinkTest() {
        TeamDataFixture.class.$init$((TeamDataFixture)this);
        ScanGraphInit$class.$init$(this);
        this.tempDir = new TemporaryFolder();
        this.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName = "teamdata";
        this.namespace = "teamDatasource";
        this.it().apply("writes the correct script file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Neo4jBulkCSVDataSinkTest $outer;

            public final Assertion apply() {
                String root = this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds().rootPath();
                String scriptFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{root, this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), Neo4jBulkCSVDataSink$.MODULE$.SCRIPT_NAME()}));
                String expected = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                     |#!/bin/sh\n                     |if [ $# -ne 1 ]\n                     |then\n                     |  echo \"Please provide the path to your Neo4j installation (e.g. /usr/share/neo4j/)\"\n                     |else\n                     |  ${1}bin/neo4j-admin import \\\\\n                     |  --database=teamdata \\\\\n                     |  --delimiter=\",\" \\\\\n                     |  --array-delimiter=\"|\" \\\\\n                     |  --id-type=INTEGER \\\\\n                     |  --nodes:Person \"", "/teamdata/nodes/Person/schema.csv,", "/teamdata/nodes/Person/part(.*)\\\\.csv\" \\\\\n                     |  --nodes:Person:German \"", "/teamdata/nodes/German_Person/schema.csv,", "/teamdata/nodes/German_Person/part(.*)\\\\.csv\" \\\\\n                     |  --nodes:Person:Swede \"", "/teamdata/nodes/Person_Swede/schema.csv,", "/teamdata/nodes/Person_Swede/part(.*)\\\\.csv\" \\\\\n                     |  --relationships:KNOWS \"", "/teamdata/relationships/KNOWS/schema.csv,", "/teamdata/relationships/KNOWS/part(.*)\\\\.csv\"\n                     |fi\n                     |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{root, root, root, root, root, root, root, root})))).stripMargin();
                return this.$outer.convertToStringShouldWrapper(Source$.MODULE$.fromFile(scriptFilePath, Codec$.MODULE$.fallbackSystemCodec()).mkString(), new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default()).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.it().apply("writes the correct schema files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Neo4jBulkCSVDataSinkTest $outer;

            public final Assertion apply() {
                this.$outer.convertToStringShouldWrapper(Source$.MODULE$.fromFile(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds().schemaFileForNodes(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person", "German"}))), Codec$.MODULE$.fallbackSystemCodec()).mkString(), new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89), Prettifier$.MODULE$.default()).should(this.$outer.equal("___capsID:ID,languages:string[],luckyNumber:int,name:string"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(Source$.MODULE$.fromFile(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds().schemaFileForNodes(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}))), Codec$.MODULE$.fallbackSystemCodec()).mkString(), new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).should(this.$outer.equal("___capsID:ID,languages:string[],luckyNumber:int,name:string"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(Source$.MODULE$.fromFile(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds().schemaFileForNodes(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person", "Swede"}))), Codec$.MODULE$.fallbackSystemCodec()).mkString(), new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97), Prettifier$.MODULE$.default()).should(this.$outer.equal("___capsID:ID,luckyNumber:int,name:string"), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToStringShouldWrapper(Source$.MODULE$.fromFile(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$ds().schemaFileForRelationships(this.$outer.org$opencypher$spark$api$io$neo4j$Neo4jBulkCSVDataSinkTest$$graphName(), "KNOWS"), Codec$.MODULE$.fallbackSystemCodec()).mkString(), new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.$outer.equal(":START_ID,:END_ID,since:int"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("Neo4jBulkCSVDataSinkTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }
}

