/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validations.oas;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.validation.GenericValidator;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validations.oas.OperationWrapper;
import org.openapitools.codegen.validations.oas.RuleConfiguration;

class OpenApiOperationValidations
extends GenericValidator<OperationWrapper> {
    OpenApiOperationValidations(RuleConfiguration ruleConfiguration) {
        super(new ArrayList());
        if (ruleConfiguration.isEnableRecommendations() && ruleConfiguration.isEnableApiRequestUriWithBodyRecommendation()) {
            this.rules.add(ValidationRule.warn((String)"API GET/HEAD defined with request body", (String)"While technically allowed, GET/HEAD with request body may indicate programming error, and is considered an anti-pattern.", OpenApiOperationValidations::checkAntipatternGetOrHeadWithBody));
        }
    }

    private static ValidationRule.Result checkAntipatternGetOrHeadWithBody(OperationWrapper wrapper) {
        RequestBody body;
        if (wrapper == null) {
            return ValidationRule.Pass.empty();
        }
        ValidationRule.Result result = ValidationRule.Pass.empty();
        if ((wrapper.getHttpMethod() == PathItem.HttpMethod.GET || wrapper.getHttpMethod() == PathItem.HttpMethod.HEAD) && (body = wrapper.getOperation().getRequestBody()) != null && (StringUtils.isNotEmpty((CharSequence)body.get$ref()) || body.getContent() != null && body.getContent().size() > 0)) {
            result = new ValidationRule.Fail();
            result.setDetails(String.format(Locale.ROOT, "%s %s contains a request body and is considered an anti-pattern.", wrapper.getHttpMethod().name(), wrapper.getOperation().getOperationId()));
        }
        return result;
    }
}

