/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaskellYesodServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "projectName";
    public static final String API_MODULE_NAME = "apiModuleName";
    private static final Pattern LEADING_UNDERSCORE = Pattern.compile("^_+");
    private final Logger LOGGER = LoggerFactory.getLogger(HaskellYesodServerCodegen.class);
    protected String projectName;
    protected String apiModuleName;

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "haskell-yesod";
    }

    @Override
    public String getHelp() {
        return "Generates a haskell-yesod server.";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApiModuleName() {
        return this.apiModuleName;
    }

    public void setApiModuleName(String apiModuleName) {
        this.apiModuleName = apiModuleName;
    }

    public HaskellYesodServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Callbacks}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.specialCharReplacements.put("-", "Dash");
        this.specialCharReplacements.put(">", "GreaterThan");
        this.specialCharReplacements.put("<", "LessThan");
        this.outputFolder = "generated-code" + File.separator + "haskell-yesod";
        this.apiTemplateFiles.put("api.mustache", ".hs");
        this.apiTestTemplateFiles.put("api_test.mustache", ".hs");
        this.templateDir = "haskell-yesod";
        this.embeddedTemplateDir = "haskell-yesod";
        this.apiNameSuffix = "";
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "family", "default", "deriving", "do", "forall", "foreign", "hiding", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "Int", "Int64", "Float", "Double", "Text", "Day", "UTCTime"));
        this.typeMapping.clear();
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("string", "Text");
        this.typeMapping.put("date", "Day");
        this.typeMapping.put("DateTime", "UTCTime");
        this.typeMapping.put("decimal", "Text");
        this.typeMapping.put("URI", "Text");
        this.typeMapping.put("UUID", "Text");
        this.typeMapping.put("ByteArray", "Text");
        this.typeMapping.put("binary", "Text");
        this.typeMapping.put("file", "Text");
        this.typeMapping.put("AnyType", "Value");
        this.importMapping.clear();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "name of the project (Default: generated from info.title or \"openapi-haskell-yesod-server\")"));
        this.cliOptions.add(new CliOption(API_MODULE_NAME, "name of the API module (Default: generated from info.title or \"API\")"));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + "Handler";
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + "test" + File.separator + "Handler";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Spec";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("HASKELL_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Hint: Environment variable HASKELL_POST_PROCESS_FILE not defined so the Haskell code may not be properly formatted. To define it, try 'export HASKELL_POST_PROCESS_FILE=\"$HOME/.local/bin/hfmt -w\"' (Linux/Mac)");
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        }
        if (this.additionalProperties.containsKey(API_MODULE_NAME)) {
            this.setApiModuleName((String)this.additionalProperties.get(API_MODULE_NAME));
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Object[] replacementChars;
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName) && info.getTitle() != null) {
                this.projectName = StringUtils.dashize(this.sanitizeName(info.getTitle()));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.apiModuleName) && info.getTitle() != null) {
                this.apiModuleName = StringUtils.camelize(this.sanitizeName(info.getTitle()));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName)) {
            this.projectName = "openapi-haskell-yesod-server";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.apiModuleName)) {
            this.apiModuleName = "API";
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(API_MODULE_NAME, this.apiModuleName);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("app/DevelMain.mustache", "app", "DevelMain.hs"));
        this.supportingFiles.add(new SupportingFile("app/devel.mustache", "app", "devel.hs"));
        this.supportingFiles.add(new SupportingFile("app/main.hs", "app", "main.hs"));
        this.supportingFiles.add(new SupportingFile("config/keter.mustache", "config", "keter.yml"));
        this.supportingFiles.add(new SupportingFile("config/routes.mustache", "config", "routes.yesodroutes"));
        this.supportingFiles.add(new SupportingFile("config/settings.yml", "config", "settings.yml"));
        this.supportingFiles.add(new SupportingFile("config/test-settings.yml", "config", "test-settings.yml"));
        this.supportingFiles.add(new SupportingFile("dir-locals.el", "", ".dir-locals.el"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.yaml"));
        this.supportingFiles.add(new SupportingFile("src/API/Types.mustache", "src" + File.separator + this.apiModuleName, "Types.hs"));
        this.supportingFiles.add(new SupportingFile("src/Application.mustache", "src", "Application.hs"));
        this.supportingFiles.add(new SupportingFile("src/Error.hs", "src", "Error.hs"));
        this.supportingFiles.add(new SupportingFile("src/Foundation.hs", "src", "Foundation.hs"));
        this.supportingFiles.add(new SupportingFile("src/Import/NoFoundation.mustache", "src" + File.separator + "Import", "NoFoundation.hs"));
        this.supportingFiles.add(new SupportingFile("src/Import.hs", "src", "Import.hs"));
        this.supportingFiles.add(new SupportingFile("src/Settings/StaticFiles.hs", "src" + File.separator + "Settings", "StaticFiles.hs"));
        this.supportingFiles.add(new SupportingFile("src/Settings.hs", "src", "Settings.hs"));
        this.supportingFiles.add(new SupportingFile("stack.yaml", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("static/gitkeep", "static", ".gitkeep"));
        this.supportingFiles.add(new SupportingFile("test/Spec.hs", "test", "Spec.hs"));
        this.supportingFiles.add(new SupportingFile("test/TestImport.hs", "test", "TestImport.hs"));
        ArrayList replacements = new ArrayList();
        for (Object replacementChar : replacementChars = this.specialCharReplacements.keySet().toArray()) {
            String c = (String)replacementChar;
            HashMap<String, String> o = new HashMap<String, String>();
            o.put("char", c);
            o.put("replacement", (String)this.specialCharReplacements.get(c));
            replacements.add(o);
        }
        this.additionalProperties.put("specialCharReplacements", replacements);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "(Map.Map String " + this.getTypeDeclaration(inner) + ")";
        }
        return this.fixModelChars(super.getTypeDeclaration(p));
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        this.LOGGER.debug("debugging OpenAPI type: {}, {} => {}", new Object[]{p.getType(), p.getFormat(), schemaType});
        Object type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            return type;
        }
        type = this.typeMapping.containsValue(schemaType) ? schemaType + "_" : schemaType;
        return this.toModelName((String)type);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            Schema additionalProperties2 = ModelUtils.getAdditionalProperties(p);
            String type = additionalProperties2.getType();
            if (null == type) {
                this.LOGGER.error("No Type defined for Additional Property {}\n\tIn Property: {}", (Object)additionalProperties2, (Object)p);
            }
            String inner = this.getSchemaType(additionalProperties2);
            return "(Map.Map Text " + inner + ")";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return inner;
        }
        return null;
    }

    private List<String> pathToComponents(String path, List<CodegenParameter> pathParams) {
        HashMap<String, String> captureTypes = new HashMap<String, String>();
        for (CodegenParameter param : pathParams) {
            captureTypes.put(param.baseName, param.dataType);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> components = new ArrayList<String>();
        for (String piece : path.split("/")) {
            if (piece.startsWith("{") && piece.endsWith("}")) {
                String name = piece.substring(1, piece.length() - 1);
                components.add("#" + (String)captureTypes.get(name));
                continue;
            }
            components.add(piece);
        }
        return components;
    }

    private String pathToYesodPath(String path, List<CodegenParameter> pathParams) {
        return "/" + String.join((CharSequence)"/", this.pathToComponents(path, pathParams));
    }

    private String pathToYesodResource(String path, List<CodegenParameter> pathParams) {
        Object resource = "";
        for (String component : this.pathToComponents(path, pathParams)) {
            if (component.startsWith("#")) {
                resource = (String)resource + "By" + StringUtils.camelize(component.substring(1));
                continue;
            }
            resource = (String)resource + StringUtils.camelize(component);
        }
        if (((String)resource).isEmpty()) {
            resource = StringUtils.camelize(this.apiModuleName) + "Home";
        }
        resource = (String)resource + "R";
        return resource;
    }

    @Override
    public CodegenOperation fromOperation(String resourcePath, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(resourcePath, httpMethod, operation, servers);
        Object path = this.pathToYesodPath(op.path, op.pathParams);
        String resource = this.pathToYesodResource(op.path, op.pathParams);
        ArrayList<Map<String, Object>> routes = (ArrayList<Map<String, Object>>)this.additionalProperties.get("routes");
        if (routes == null) {
            routes = new ArrayList<Map<String, Object>>();
            this.additionalProperties.put("routes", routes);
        }
        if (this.hasOverlappedPath((String)path, routes).booleanValue()) {
            path = "!" + (String)path;
        }
        Boolean found = false;
        for (Map map : routes) {
            if (!((String)path).equals(map.get("path"))) continue;
            List methods = (List)map.get("methods");
            methods.add(op.httpMethod);
            found = true;
            break;
        }
        if (!found.booleanValue()) {
            HashMap<String, Object> route = new HashMap<String, Object>();
            route.put("path", path);
            route.put("resource", resource);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(op.httpMethod);
            route.put("methods", arrayList);
            routes.add(route);
        }
        String handler = httpMethod.toLowerCase(Locale.ROOT) + resource;
        String string = org.apache.commons.lang3.StringUtils.repeat((String)" ", (int)handler.length());
        op.vendorExtensions.put("x-handler", handler);
        op.vendorExtensions.put("x-param-indent", string);
        op.vendorExtensions.put("x-resource", resource);
        op.vendorExtensions.put("x-is-get-or-post", op.httpMethod.equals("GET") || op.httpMethod.equals("POST"));
        for (CodegenParameter param : op.pathParams) {
            param.vendorExtensions.put("x-handler", handler);
            param.vendorExtensions.put("x-param-indent", string);
            param.vendorExtensions.put("x-test-value", this.getParameterTestValue(param));
        }
        return op;
    }

    public Boolean hasOverlappedPath(String path, List<Map<String, Object>> routes) {
        for (Map<String, Object> route : routes) {
            String processedPath = (String)route.get("path");
            if (processedPath.startsWith("!") || !this.isOverlappedPath(path, processedPath).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean isOverlappedPath(String pathA, String pathB) {
        String[] componentsB;
        if (pathA.equals(pathB)) {
            return false;
        }
        String[] componentsA = pathA.split("/");
        if (componentsA.length != (componentsB = pathB.split("/")).length) {
            return false;
        }
        for (int i = 0; i < componentsA.length; ++i) {
            if (componentsA[i].equals(componentsB[i]) || componentsA[i].startsWith("#") || componentsB[i].startsWith("#")) continue;
            return false;
        }
        return true;
    }

    private String getParameterTestValue(CodegenParameter codegenParameter) {
        if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            return codegenParameter.example;
        }
        if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isUri)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isString)) {
            return "\"" + codegenParameter.example + "\"";
        }
        if (Boolean.TRUE.equals(codegenParameter.isFreeFormObject)) {
            return "\"" + codegenParameter.example + "\"";
        }
        return "unknown";
    }

    private String fixModelChars(String string) {
        return string.replace(".", "").replace("-", "");
    }

    @Override
    public CodegenModel fromModel(String name, Schema mod) {
        CodegenModel model = super.fromModel(name, mod);
        model.classname = this.fixModelChars(model.classname);
        if (this.typeMapping.containsValue(model.classname)) {
            model.classname = model.classname + "_";
        }
        String prefix = StringUtils.camelize(model.classname, CamelizeOption.LOWERCASE_FIRST_LETTER);
        for (CodegenProperty prop : model.vars) {
            prop.name = this.toVarName(prefix + StringUtils.camelize(prop.name));
            prop.vendorExtensions.put("x-base-name-string-literal", "\"" + this.escapeText(prop.getBaseName()) + "\"");
        }
        String dataOrNewtype = "data";
        if (!"object".equals(model.dataType) && this.typeMapping.containsKey(model.dataType)) {
            String newtype = (String)this.typeMapping.get(model.dataType);
            model.vendorExtensions.put("x-custom-newtype", newtype);
        }
        model.vendorExtensions.put("x-data", dataOrNewtype);
        return model;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("{-", "{_-").replace("-}", "-_}");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String haskellPostProcessFile = System.getenv("HASKELL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)haskellPostProcessFile)) {
            return;
        }
        if ("hs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = haskellPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.HASKELL;
    }
}

