/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.JavaHelidonCommonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHelidonClientCodegen
extends JavaHelidonCommonCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(JavaHelidonClientCodegen.class);
    private static final String X_HELIDON_REQUIRED_IMPL_IMPORTS = "x-helidon-requiredImplImports";
    private static final String X_HELIDON_IMPL_IMPORTS = "x-helidon-implImports";
    public static final String CONFIG_KEY = "configKey";
    protected String configKey = null;
    protected boolean useBeanValidation = false;
    protected boolean performBeanValidation = false;
    protected boolean useGzipFeature = false;
    protected boolean caseInsensitiveResponseHeaders = false;
    protected Path invokerFolder;
    protected Path apiFolder;
    protected String serializationLibrary = null;

    public JavaHelidonClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}));
        this.outputFolder = "generated-code" + File.separator + "java";
        this.embeddedTemplateDir = "java-helidon" + File.separator + "common";
        this.templateDir = "java-helidon" + File.separator + "client";
        this.invokerPackage = "org.openapitools.client";
        this.artifactId = "openapi-java-client";
        this.apiPackage = this.invokerPackage + ".api";
        this.modelPackage = this.invokerPackage + ".model";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.modelTestTemplateFiles.put("model_test.mustache", ".java");
        this.cliOptions.add(CliOption.newString(CONFIG_KEY, "Config key in @RegisterRestClient. Default to none."));
        this.supportedLibraries.put("mp", "Helidon MP Client");
        this.supportedLibraries.put("se", "Helidon SE Client");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault("mp");
        this.cliOptions.add(libraryOption);
        this.setLibrary("mp");
        CliOption serializationLibrary = new CliOption("serializationLibrary", "Serialization library, defaults to Jackson");
        HashMap<String, String> serializationOptions = new HashMap<String, String>();
        serializationOptions.put("jackson", "Use Jackson as serialization library");
        serializationOptions.put("jsonb", "Use JSON-B as serialization library");
        serializationLibrary.setEnum(serializationOptions);
        this.cliOptions.add(serializationLibrary);
        this.setSerializationLibrary("jackson");
        this.removeUnusedOptions();
        this.setLegacyDiscriminatorBehavior(false);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "java-helidon-client";
    }

    @Override
    public String getHelp() {
        return "Generates a Helidon MP or SE client";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        if ("mp".equals(this.getLibrary())) {
            co.subresourceOperation = !co.path.isEmpty();
        }
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        if (templateName.contains("_impl")) {
            String suffix = this.apiTemplateFiles().get(templateName);
            return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + "Impl" + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary(this.additionalProperties.get("serializationLibrary").toString());
        }
        if (this.additionalProperties.containsKey(CONFIG_KEY)) {
            this.setConfigKey(this.additionalProperties.get(CONFIG_KEY).toString());
        }
        String invokerPath = this.invokerPackage.replace('.', File.separatorChar);
        this.invokerFolder = Paths.get(this.sourceFolder, invokerPath);
        this.apiFolder = Paths.get(this.outputFolder, new String[0]).relativize(Paths.get(this.apiFileFolder(), new String[0]));
        if (this.isLibrary("mp")) {
            String apiExceptionFolder = Paths.get(this.sourceFolder, this.apiPackage().replace('.', File.separatorChar)).toString();
            ArrayList<SupportingFile> modifiable = new ArrayList<SupportingFile>();
            modifiable.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            modifiable.add(new SupportingFile("README.mustache", "", "README.md"));
            ArrayList<SupportingFile> unmodifiable = new ArrayList<SupportingFile>();
            unmodifiable.add(new SupportingFile("api_exception.mustache", apiExceptionFolder, "ApiException.java"));
            unmodifiable.add(new SupportingFile("api_exception_mapper.mustache", apiExceptionFolder, "ApiExceptionMapper.java"));
            if (this.additionalProperties.containsKey("jsr310")) {
                unmodifiable.add(new SupportingFile("JavaTimeFormatter.mustache", this.invokerFolder.toString(), "JavaTimeFormatter.java"));
            }
            this.processSupportingFiles(modifiable, unmodifiable);
        } else if (this.isLibrary("se")) {
            this.apiTemplateFiles.put("api_impl.mustache", ".java");
            this.importMapping.put("StringJoiner", "java.util.StringJoiner");
            this.importMapping.put("WebClientRequestHeaders", "io.helidon.webclient.WebClientRequestHeaders");
            this.importMapping.put("Pair", this.invokerPackage + ".Pair");
            ArrayList<SupportingFile> modifiable = new ArrayList<SupportingFile>();
            modifiable.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            modifiable.add(new SupportingFile("README.mustache", "", "README.md"));
            ArrayList<SupportingFile> unmodifiable = new ArrayList<SupportingFile>();
            unmodifiable.add(new SupportingFile("ApiResponse.mustache", this.invokerFolder.toString(), "ApiResponse.java"));
            unmodifiable.add(new SupportingFile("ApiResponseBase.mustache", this.invokerFolder.toString(), "ApiResponseBase.java"));
            unmodifiable.add(new SupportingFile("ApiClient.mustache", this.invokerFolder.toString(), "ApiClient.java"));
            unmodifiable.add(new SupportingFile("Pair.mustache", this.invokerFolder.toString(), "Pair.java"));
            unmodifiable.add(new SupportingFile("ResponseType.mustache", this.apiFolder.toString(), "ResponseType.java"));
            this.processSupportingFiles(modifiable, unmodifiable);
        } else {
            this.LOGGER.error("Unknown library option (-l/--library): {}", (Object)this.getLibrary());
        }
        if (this.getSerializationLibrary() == null) {
            this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)"jackson");
            this.setSerializationLibrary("jackson");
        }
        switch (this.getSerializationLibrary()) {
            case "jackson": {
                this.additionalProperties.put("jackson", "true");
                this.additionalProperties.remove("jsonb");
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", this.invokerFolder.toString(), "RFC3339DateFormat.java"));
                break;
            }
            case "jsonb": {
                this.openApiNullable = false;
                this.additionalProperties.put("jsonb", "true");
                this.additionalProperties.remove("jackson");
                break;
            }
            default: {
                this.additionalProperties.remove("jackson");
                this.additionalProperties.remove("jsonb");
                this.LOGGER.error("Unknown serialization library option");
            }
        }
    }

    @Override
    protected boolean projectFilesExist() {
        Path projectFolder = Paths.get(this.getOutputTestFolder(), new String[0]);
        Path pom = projectFolder.resolve("pom.xml");
        Path src = projectFolder.resolve(this.invokerFolder);
        return pom.toFile().exists() && src.toFile().exists();
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        if (this.isLibrary("mp")) {
            super.postProcessOperationsWithModels(objs, allModels);
            return AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
        }
        List<Map<String, String>> imports = objs.getImports();
        ArrayList<Map<String, String>> implImports = new ArrayList<Map<String, String>>(imports);
        HashSet requiredImplImportClassNames = new HashSet();
        for (CodegenOperation op : objs.getOperations().getOperation()) {
            requiredImplImportClassNames.addAll((Set)op.vendorExtensions.get(X_HELIDON_REQUIRED_IMPL_IMPORTS));
        }
        TreeSet missingImportClassNames = new TreeSet(requiredImplImportClassNames);
        imports.stream().map(m -> (String)m.get("classname")).forEach(missingImportClassNames::remove);
        missingImportClassNames.forEach(c -> {
            HashMap<String, String> singleImportMap = new HashMap<String, String>();
            singleImportMap.put("classname", (String)c);
            singleImportMap.put("import", (String)Objects.requireNonNull(this.importMapping.get(c), "no mapping for " + c));
            implImports.add(singleImportMap);
        });
        objs.put(X_HELIDON_IMPL_IMPORTS, implImports);
        return objs;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        TreeSet<String> requiredImplImports = new TreeSet<String>();
        if (op.isArray) {
            op.imports.add("List");
        }
        if (op.isMap) {
            op.imports.add("Map");
        }
        if (op.getHasQueryParams()) {
            requiredImplImports.add("List");
            requiredImplImports.add("ArrayList");
            requiredImplImports.add("Pair");
        }
        if (op.getHasHeaderParams()) {
            requiredImplImports.add("WebClientRequestHeaders");
        }
        if (op.getHasFormParams()) {
            requiredImplImports.add("StringJoiner");
        }
        if (op.getHasCookieParams()) {
            requiredImplImports.add("StringJoiner");
        }
        if (op.bodyParams.stream().anyMatch(JavaHelidonClientCodegen::checkIsArray) || op.allParams.stream().anyMatch(JavaHelidonClientCodegen::checkIsArray) || op.responses.stream().anyMatch(CodegenResponse::getIsArray)) {
            requiredImplImports.add("List");
            op.imports.add("List");
        }
        if (op.bodyParams.stream().anyMatch(JavaHelidonClientCodegen::checkIsMap) || op.allParams.stream().anyMatch(JavaHelidonClientCodegen::checkIsMap) || op.responses.stream().anyMatch(CodegenResponse::getIsMap)) {
            requiredImplImports.add("Map");
            op.imports.add("Map");
        }
        op.vendorExtensions.put(X_HELIDON_REQUIRED_IMPL_IMPORTS, requiredImplImports);
        return op;
    }

    private static boolean checkIsArray(CodegenParameter p) {
        return p.isArray || p.getSchema() == null || !p.getSchema().getIsArray();
    }

    private static boolean checkIsMap(CodegenParameter p) {
        return p.isMap || p.getSchema() == null || !p.getSchema().getIsMap();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum) && this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonProperty");
            model.imports.add("JsonValue");
            model.imports.add("JsonInclude");
            model.imports.add("JsonTypeName");
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
        if ("mp".equals(this.getLibrary())) {
            model.imports.remove("ApiModelProperty");
            model.imports.remove("ApiModel");
            model.imports.remove("JsonSerialize");
            model.imports.remove("ToStringSerializer");
        } else if ("se".equals(this.getLibrary())) {
            model.imports.remove("ApiModelProperty");
            model.imports.remove("ApiModel");
            model.imports.remove("JsonSerialize");
            model.imports.remove("ToStringSerializer");
        }
        if ("set".equals(property.containerType) && !"jackson".equals(this.serializationLibrary)) {
            model.imports.remove("JsonDeserialize");
            property.vendorExtensions.remove("x-setter-extra-annotation");
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (this.isLibrary("mp")) {
            if (codegenModel.imports.contains("ApiModel")) {
                codegenModel.imports.remove("ApiModel");
            }
        } else if (this.isLibrary("se") && codegenModel.imports.contains("ApiModel")) {
            codegenModel.imports.remove("ApiModel");
        }
        return codegenModel;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<ModelMap> models = objs.getModels();
        if (this.additionalProperties.containsKey("jackson")) {
            List<Map<String, String>> imports = objs.getImports();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                boolean addImports = false;
                for (CodegenProperty var : cm.vars) {
                    if (this.openApiNullable) {
                        boolean isOptionalNullable = Boolean.FALSE.equals(var.required) && Boolean.TRUE.equals(var.isNullable);
                        addImports |= isOptionalNullable;
                        var.getVendorExtensions().put("x-is-jackson-optional-nullable", isOptionalNullable);
                    }
                    if (!Boolean.TRUE.equals(var.getVendorExtensions().get("x-enum-as-string"))) continue;
                    var.datatypeWithEnum = var.dataType;
                    if (StringUtils.isNotEmpty((CharSequence)var.defaultValue)) {
                        String defaultValue = var.defaultValue.substring(var.defaultValue.lastIndexOf(46) + 1);
                        for (Map enumVars : (List)var.getAllowableValues().get("enumVars")) {
                            if (!defaultValue.equals(enumVars.get("name"))) continue;
                            var.defaultValue = (String)enumVars.get("value");
                        }
                    }
                    cm.imports.add("Set");
                    HashMap<String, String> importsSet = new HashMap<String, String>();
                    importsSet.put("import", "java.util.Set");
                    imports.add(importsSet);
                    HashMap<String, String> importsHashSet = new HashMap<String, String>();
                    importsHashSet.put("import", "java.util.HashSet");
                    imports.add(importsHashSet);
                }
                if (!addImports) continue;
                HashMap<String, String> imports2Classnames = new HashMap<String, String>();
                imports2Classnames.put("JsonNullable", "org.openapitools.jackson.nullable.JsonNullable");
                imports2Classnames.put("NoSuchElementException", "java.util.NoSuchElementException");
                imports2Classnames.put("JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
                for (Map.Entry entry : imports2Classnames.entrySet()) {
                    cm.imports.add((String)entry.getKey());
                    HashMap importsItem = new HashMap();
                    importsItem.put("import", entry.getValue());
                    imports.add(importsItem);
                }
            }
        }
        return objs;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    public void setUseGzipFeature(boolean useGzipFeature) {
        this.useGzipFeature = useGzipFeature;
    }

    public void setCaseInsensitiveResponseHeaders(Boolean caseInsensitiveResponseHeaders) {
        this.caseInsensitiveResponseHeaders = caseInsensitiveResponseHeaders;
    }

    public String getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        if ("jackson".equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = "jackson";
        } else if ("jsonb".equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = "jsonb";
        } else {
            throw new IllegalArgumentException("Unexpected serializationLibrary value: " + serializationLibrary);
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    @Override
    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
        for (String i : Arrays.asList("JsonSubTypes", "JsonTypeInfo", "JsonIgnoreProperties")) {
            HashMap oneImport = new HashMap();
            oneImport.put("import", this.importMapping.get(i));
            if (imports.contains(oneImport)) continue;
            imports.add(oneImport);
        }
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        List<VendorExtension> extensions = super.getSupportedVendorExtensions();
        extensions.add(VendorExtension.X_WEBCLIENT_BLOCKING);
        return extensions;
    }
}

