/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPINormalizer {
    private OpenAPI openAPI;
    private Map<String, String> rules = new HashMap<String, String>();
    final Logger LOGGER = LoggerFactory.getLogger(OpenAPINormalizer.class);
    final String ALL = "ALL";
    boolean enableAll;
    final String REF_AS_PARENT_IN_ALLOF = "REF_AS_PARENT_IN_ALLOF";
    boolean enableRefAsParentInAllOf;
    final String KEEP_ONLY_FIRST_TAG_IN_OPERATION = "KEEP_ONLY_FIRST_TAG_IN_OPERATION";
    boolean enableKeepOnlyFirstTagInOperation;
    final String REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY = "REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY";
    boolean removeAnyOfOneOfAndKeepPropertiesOnly;
    final String SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING = "SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING";
    boolean simplifyAnyOfStringAndEnumString;

    public OpenAPINormalizer(OpenAPI openAPI, Map<String, String> rules) {
        this.openAPI = openAPI;
        this.rules = rules;
        this.parseRules(rules);
    }

    public void parseRules(Map<String, String> rules) {
        if (rules == null) {
            return;
        }
        if ("true".equalsIgnoreCase(rules.get("ALL"))) {
            this.enableAll = true;
        }
        if (this.enableAll || "true".equalsIgnoreCase(rules.get("REF_AS_PARENT_IN_ALLOF"))) {
            this.enableRefAsParentInAllOf = true;
        }
        if (this.enableAll || "true".equalsIgnoreCase(rules.get("KEEP_ONLY_FIRST_TAG_IN_OPERATION"))) {
            this.enableKeepOnlyFirstTagInOperation = true;
        }
        if (this.enableAll || "true".equalsIgnoreCase(rules.get("REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY"))) {
            this.removeAnyOfOneOfAndKeepPropertiesOnly = true;
        }
        if (this.enableAll || "true".equalsIgnoreCase(rules.get("SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING"))) {
            this.simplifyAnyOfStringAndEnumString = true;
        }
    }

    void normalize() {
        if (this.rules == null || this.rules.isEmpty()) {
            return;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new HashMap());
        }
        this.normalizePaths();
        this.normalizeComponents();
    }

    private void normalizePaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            PathItem path = (PathItem)pathsEntry.getValue();
            ArrayList operations = new ArrayList(path.readOperations());
            for (Operation operation : path.readOperations()) {
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                operations.addAll(callbacks.values().stream().flatMap(callback -> callback.values().stream()).flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList()));
            }
            for (Operation operation : operations) {
                this.normalizeOperation(operation);
                this.normalizeRequestBody(operation);
                this.normalizeParameters(operation);
                this.normalizeResponses(operation);
            }
        }
    }

    private void normalizeOperation(Operation operation) {
        this.processKeepOnlyFirstTagInOperation(operation);
    }

    private void normalizeContent(Content content) {
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String contentType : content.keySet()) {
            MediaType mediaType = (MediaType)content.get((Object)contentType);
            if (mediaType == null || mediaType.getSchema() == null) continue;
            this.normalizeSchema(mediaType.getSchema(), new HashSet<Schema>());
        }
    }

    private void normalizeRequestBody(Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        if (requestBody.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef(requestBody.get$ref());
            requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(ref);
            if (requestBody == null) {
                return;
            }
        }
        this.normalizeContent(requestBody.getContent());
    }

    private void normalizeParameters(Operation operation) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            if (parameter.getSchema() == null) continue;
            this.normalizeSchema(parameter.getSchema(), new HashSet<Schema>());
        }
    }

    private void normalizeResponses(Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            if (responsesEntry.getValue() == null) continue;
            this.normalizeContent(((ApiResponse)responsesEntry.getValue()).getContent());
        }
    }

    private void normalizeComponents() {
        Map schemas = this.openAPI.getComponents().getSchemas();
        if (schemas == null) {
            return;
        }
        ArrayList schemaNames = new ArrayList(schemas.keySet());
        for (String schemaName : schemaNames) {
            Schema schema = (Schema)schemas.get(schemaName);
            if (schema == null) {
                this.LOGGER.warn("{} not fount found in openapi/components/schemas.", (Object)schemaName);
                continue;
            }
            Schema result = this.normalizeSchema(schema, new HashSet<Schema>());
            schemas.put(schemaName, result);
        }
    }

    public Schema normalizeSchema(Schema schema, Set<Schema> visitedSchemas) {
        if (schema == null) {
            return schema;
        }
        if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            return schema;
        }
        if (visitedSchemas.contains(schema)) {
            return schema;
        }
        visitedSchemas.add(schema);
        if (schema instanceof ArraySchema) {
            this.normalizeSchema(schema.getItems(), visitedSchemas);
        } else if (schema.getAdditionalProperties() instanceof Schema) {
            this.normalizeSchema((Schema)schema.getAdditionalProperties(), visitedSchemas);
        } else {
            if (ModelUtils.isComposedSchema(schema)) {
                ComposedSchema cs = (ComposedSchema)schema;
                if (ModelUtils.isComplexComposedSchema((Schema)cs)) {
                    cs = (ComposedSchema)this.normalizeComplexComposedSchema((Schema)cs, visitedSchemas);
                }
                if (cs.getAllOf() != null && !cs.getAllOf().isEmpty()) {
                    return this.normalizeAllOf((Schema)cs, visitedSchemas);
                }
                if (cs.getOneOf() != null && !cs.getOneOf().isEmpty()) {
                    return this.normalizeOneOf((Schema)cs, visitedSchemas);
                }
                if (cs.getAnyOf() != null && !cs.getAnyOf().isEmpty()) {
                    return this.normalizeAnyOf((Schema)cs, visitedSchemas);
                }
                if (cs.getProperties() != null && !cs.getProperties().isEmpty()) {
                    this.normalizeProperties(cs.getProperties(), visitedSchemas);
                }
                if (cs.getAdditionalProperties() != null) {
                    // empty if block
                }
                return cs;
            }
            if (schema.getNot() != null) {
                this.normalizeSchema(schema.getNot(), visitedSchemas);
            } else if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                this.normalizeProperties(schema.getProperties(), visitedSchemas);
            } else if (schema instanceof Schema) {
                this.normalizeSchemaWithOnlyProperties(schema, visitedSchemas);
            } else {
                throw new RuntimeException("Unknown schema type found in normalizer: " + schema);
            }
        }
        return schema;
    }

    private void normalizeSchemaWithOnlyProperties(Schema schema, Set<Schema> visitedSchemas) {
    }

    private void normalizeProperties(Map<String, Schema> properties, Set<Schema> visitedSchemas) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            Schema property = propertiesEntry.getValue();
            this.normalizeSchema(property, visitedSchemas);
        }
    }

    private Schema normalizeAllOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getAllOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        this.processUseAllOfRefAsParent(schema);
        return schema;
    }

    private Schema normalizeOneOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getOneOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        return schema;
    }

    private Schema normalizeAnyOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getAnyOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        return this.processSimplifyAnyOfStringAndEnumString(schema);
    }

    private Schema normalizeComplexComposedSchema(Schema schema, Set<Schema> visitedSchemas) {
        this.processRemoveAnyOfOneOfAndKeepPropertiesOnly(schema);
        return schema;
    }

    private void processUseAllOfRefAsParent(Schema schema) {
        if (!this.enableRefAsParentInAllOf && !this.enableAll) {
            return;
        }
        for (Object item : schema.getAllOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            Schema s = (Schema)item;
            if (!StringUtils.isNotEmpty((CharSequence)s.get$ref())) continue;
            String ref = ModelUtils.getSimpleRef(s.get$ref());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(ref);
            if (refSchema == null) {
                throw new RuntimeException("schema cannot be null with ref " + ref);
            }
            if (refSchema.getExtensions() == null) {
                refSchema.setExtensions(new HashMap());
            }
            if (!refSchema.getExtensions().containsKey("x-parent")) {
                refSchema.getExtensions().put("x-parent", true);
            }
            this.LOGGER.debug("processUseAllOfRefAsParent added `x-parent: true` to {}", (Object)refSchema);
        }
    }

    private void processKeepOnlyFirstTagInOperation(Operation operation) {
        if (!this.enableKeepOnlyFirstTagInOperation) {
            return;
        }
        if (operation.getTags() != null && !operation.getTags().isEmpty() && operation.getTags().size() > 1) {
            String firstTag = (String)operation.getTags().get(0);
            operation.setTags(null);
            operation.addTagsItem(firstTag);
        }
    }

    private void processRemoveAnyOfOneOfAndKeepPropertiesOnly(Schema schema) {
        if (!this.removeAnyOfOneOfAndKeepPropertiesOnly && !this.enableAll) {
            return;
        }
        if ((schema.getOneOf() != null && !schema.getOneOf().isEmpty() || schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) && schema.getProperties() != null && !schema.getProperties().isEmpty() && schema.getAllOf() == null) {
            schema.setOneOf(null);
            schema.setAnyOf(null);
        }
    }

    private Schema processSimplifyAnyOfStringAndEnumString(Schema schema) {
        if (!this.simplifyAnyOfStringAndEnumString && !this.enableAll) {
            return schema;
        }
        Schema s0 = null;
        Schema s1 = null;
        if (schema.getAnyOf().size() != 2) {
            return schema;
        }
        s0 = ModelUtils.unaliasSchema(this.openAPI, (Schema)schema.getAnyOf().get(0));
        s1 = ModelUtils.unaliasSchema(this.openAPI, (Schema)schema.getAnyOf().get(1));
        s0 = ModelUtils.getReferencedSchema(this.openAPI, s0);
        s1 = ModelUtils.getReferencedSchema(this.openAPI, s1);
        if (s0 instanceof StringSchema && s1 instanceof StringSchema) {
            if (((StringSchema)s0).getEnum() != null) {
                return (StringSchema)s1;
            }
            if (((StringSchema)s1).getEnum() != null) {
                return (StringSchema)s0;
            }
            return schema;
        }
        return schema;
    }
}

