/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Optional;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.storageengine.api.StoreVersion;

public interface StoreVersionCheck {
    public Optional<String> storeVersion(PageCursorTracer var1);

    public String configuredVersion();

    public boolean isVersionConfigured();

    public StoreVersion versionInformation(String var1);

    public Result checkUpgrade(String var1, PageCursorTracer var2);

    public static enum Outcome {
        ok(true),
        missingStoreFile(false),
        storeVersionNotFound(false),
        unexpectedStoreVersion(false),
        attemptedStoreDowngrade(false),
        storeNotCleanlyShutDown(false),
        unexpectedUpgradingVersion(false);

        private final boolean success;

        private Outcome(boolean success) {
            this.success = success;
        }

        public boolean isSuccessful() {
            return this.success;
        }
    }

    public static class Result {
        public final Outcome outcome;
        public final String actualVersion;
        public final String storeFilename;

        public Result(Outcome outcome, String actualVersion, String storeFilename) {
            this.outcome = outcome;
            this.actualVersion = actualVersion;
            this.storeFilename = storeFilename;
        }

        public String toString() {
            return "Result{outcome=" + this.outcome + ", actualVersion='" + this.actualVersion + "', storeFilename='" + this.storeFilename + "'}";
        }
    }
}

