/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;

public class ConstraintDescriptorImplementation
implements ConstraintDescriptor,
NodeExistenceConstraintDescriptor,
NodeKeyConstraintDescriptor,
RelExistenceConstraintDescriptor,
UniquenessConstraintDescriptor {
    private final ConstraintType type;
    private final SchemaDescriptor schema;
    private final long id;
    private final String name;
    private final Long ownedIndex;

    ConstraintDescriptorImplementation(ConstraintType type, SchemaDescriptor schema) {
        this.type = type;
        this.schema = schema;
        this.id = -1L;
        this.name = null;
        this.ownedIndex = null;
    }

    private ConstraintDescriptorImplementation(ConstraintType type, SchemaDescriptor schema, long id, String name, Long ownedIndex) {
        this.type = type;
        this.schema = schema;
        this.id = id;
        this.name = name;
        this.ownedIndex = ownedIndex;
    }

    @Override
    public ConstraintType type() {
        return this.type;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean enforcesUniqueness() {
        return this.type.enforcesUniqueness();
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return this.type.enforcesPropertyExistence();
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, this.type, this.schema(), this.ownedIndex);
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.EXISTS;
    }

    @Override
    public RelExistenceConstraintDescriptor asRelationshipPropertyExistenceConstraint() {
        if (!this.isRelationshipPropertyExistenceConstraint()) {
            throw this.conversionException(RelExistenceConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.EXISTS;
    }

    @Override
    public NodeExistenceConstraintDescriptor asNodePropertyExistenceConstraint() {
        if (!this.isNodePropertyExistenceConstraint()) {
            throw this.conversionException(NodeExistenceConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isUniquenessConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        if (!this.isUniquenessConstraint()) {
            throw this.conversionException(UniquenessConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE_EXISTS;
    }

    @Override
    public NodeKeyConstraintDescriptor asNodeKeyConstraint() {
        if (!this.isNodeKeyConstraint()) {
            throw this.conversionException(NodeKeyConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return this.isUniquenessConstraint() || this.isNodeKeyConstraint();
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        if (!this.isIndexBackedConstraint()) {
            throw this.conversionException(IndexBackedConstraintDescriptor.class);
        }
        return this;
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + targetType + " because it does not match that structure: " + this + ".");
    }

    public final boolean equals(Object o) {
        if (o instanceof ConstraintDescriptor) {
            ConstraintDescriptor that = (ConstraintDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public final int hashCode() {
        return this.type.hashCode() & this.schema().hashCode();
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + this);
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasOwnedIndexId() {
        return this.ownedIndex != null;
    }

    @Override
    public long ownedIndexId() {
        if (this.ownedIndex == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndex;
    }

    @Override
    public ConstraintDescriptorImplementation withId(long id) {
        return new ConstraintDescriptorImplementation(this.type, this.schema, id, this.name, this.ownedIndex);
    }

    @Override
    public ConstraintDescriptorImplementation withName(String name) {
        if (name == null) {
            return this;
        }
        name = SchemaRule.sanitiseName(name);
        return new ConstraintDescriptorImplementation(this.type, this.schema, this.id, name, this.ownedIndex);
    }

    @Override
    public ConstraintDescriptorImplementation withOwnedIndexId(long ownedIndex) {
        return new ConstraintDescriptorImplementation(this.type, this.schema, this.id, this.name, ownedIndex);
    }
}

