/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorImplementation;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;

public class ConstraintDescriptorFactory {
    private ConstraintDescriptorFactory() {
    }

    public static NodeExistenceConstraintDescriptor existsForLabel(int labelId, int ... propertyIds) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, SchemaDescriptor.forLabel(labelId, propertyIds));
    }

    public static RelExistenceConstraintDescriptor existsForRelType(int relTypeId, int ... propertyIds) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, SchemaDescriptor.forRelType(relTypeId, propertyIds));
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema(SchemaDescriptor.forLabel(labelId, propertyIds));
    }

    public static NodeKeyConstraintDescriptor nodeKeyForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.nodeKeyForSchema(SchemaDescriptor.forLabel(labelId, propertyIds));
    }

    public static ConstraintDescriptor existsForSchema(SchemaDescriptor schema) {
        ConstraintDescriptorImplementation constraint = new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
        if (schema.isLabelSchemaDescriptor()) {
            return constraint.asNodePropertyExistenceConstraint();
        }
        if (schema.isRelationshipTypeSchemaDescriptor()) {
            return constraint.asRelationshipPropertyExistenceConstraint();
        }
        throw new UnsupportedOperationException("Cannot create existence constraint for schema '" + schema.userDescription(TokenNameLookup.idTokenNameLookup) + "'.");
    }

    public static NodeExistenceConstraintDescriptor existsForSchema(LabelSchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
    }

    public static RelExistenceConstraintDescriptor existsForSchema(RelationTypeSchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE, schema);
    }

    public static NodeKeyConstraintDescriptor nodeKeyForSchema(SchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE_EXISTS, schema).asNodeKeyConstraint();
    }
}

