/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.LabelScanWriter;
import org.neo4j.internal.index.label.PhysicalToLogicalLabelChanges;
import org.neo4j.storageengine.api.NodeLabelUpdate;

class NativeLabelScanWriter
implements LabelScanWriter {
    private static final Comparator<NodeLabelUpdate> UPDATE_SORTER = Comparator.comparingLong(NodeLabelUpdate::getNodeId);
    private final ValueMerger<LabelScanKey, LabelScanValue> addMerger;
    private final ValueMerger<LabelScanKey, LabelScanValue> removeMerger;
    private final WriteMonitor monitor;
    private Writer<LabelScanKey, LabelScanValue> writer;
    private final LabelScanKey key = new LabelScanKey();
    private final LabelScanValue value = new LabelScanValue();
    private final NodeLabelUpdate[] pendingUpdates;
    private int pendingUpdatesCursor;
    private boolean addition;
    private long lowestLabelId;
    static final WriteMonitor EMPTY = new WriteMonitor(){};

    NativeLabelScanWriter(int batchSize, WriteMonitor monitor) {
        this.pendingUpdates = new NodeLabelUpdate[batchSize];
        this.addMerger = (existingKey, newKey, existingValue, newValue) -> {
            monitor.mergeAdd((LabelScanValue)existingValue, (LabelScanValue)newValue);
            existingValue.add((LabelScanValue)newValue);
            return ValueMerger.MergeResult.MERGED;
        };
        this.removeMerger = (existingKey, newKey, existingValue, newValue) -> {
            monitor.mergeRemove((LabelScanValue)existingValue, (LabelScanValue)newValue);
            existingValue.remove((LabelScanValue)newValue);
            return existingValue.isEmpty() ? ValueMerger.MergeResult.REMOVED : ValueMerger.MergeResult.MERGED;
        };
        this.monitor = monitor;
    }

    NativeLabelScanWriter initialize(Writer<LabelScanKey, LabelScanValue> writer) {
        this.writer = writer;
        this.pendingUpdatesCursor = 0;
        this.addition = false;
        this.lowestLabelId = Long.MAX_VALUE;
        return this;
    }

    @Override
    public void write(NodeLabelUpdate update) throws IOException {
        if (this.pendingUpdatesCursor == this.pendingUpdates.length) {
            this.flushPendingChanges();
        }
        this.pendingUpdates[this.pendingUpdatesCursor++] = update;
        PhysicalToLogicalLabelChanges.convertToAdditionsAndRemovals(update);
        this.checkNextLabelId(update.getLabelsBefore());
        this.checkNextLabelId(update.getLabelsAfter());
    }

    private void checkNextLabelId(long[] labels) {
        if (labels.length > 0 && labels[0] != -1L) {
            this.lowestLabelId = Long.min(this.lowestLabelId, labels[0]);
        }
    }

    private void flushPendingChanges() {
        Arrays.sort(this.pendingUpdates, 0, this.pendingUpdatesCursor, UPDATE_SORTER);
        this.monitor.flushPendingUpdates();
        long currentLabelId = this.lowestLabelId;
        this.value.clear();
        this.key.clear();
        while (currentLabelId != Long.MAX_VALUE) {
            long nextLabelId = Long.MAX_VALUE;
            for (int i = 0; i < this.pendingUpdatesCursor; ++i) {
                NodeLabelUpdate update = this.pendingUpdates[i];
                long nodeId = update.getNodeId();
                nextLabelId = this.extractChange(update.getLabelsAfter(), currentLabelId, nodeId, nextLabelId, true, update.getTxId());
                nextLabelId = this.extractChange(update.getLabelsBefore(), currentLabelId, nodeId, nextLabelId, false, update.getTxId());
            }
            currentLabelId = nextLabelId;
        }
        this.flushPendingRange();
        this.pendingUpdatesCursor = 0;
    }

    private long extractChange(long[] labels, long currentLabelId, long nodeId, long nextLabelId, boolean addition, long txId) {
        long labelId;
        long foundNextLabelId = nextLabelId;
        for (int li = 0; li < labels.length && (labelId = labels[li]) != -1L; ++li) {
            if (labelId == currentLabelId) {
                this.change(currentLabelId, nodeId, addition, txId);
                if (li + 1 >= labels.length || labels[li + 1] == -1L) break;
                long nextLabelCandidate = labels[li + 1];
                if (nextLabelCandidate < currentLabelId) {
                    throw new IllegalArgumentException("The node label update contained unsorted label ids " + Arrays.toString(labels));
                }
                if (nextLabelCandidate <= currentLabelId) break;
                foundNextLabelId = Long.min(foundNextLabelId, nextLabelCandidate);
                break;
            }
            if (labelId <= currentLabelId) continue;
            foundNextLabelId = Long.min(foundNextLabelId, labelId);
        }
        return foundNextLabelId;
    }

    private void change(long currentLabelId, long nodeId, boolean add, long txId) {
        int labelId = Math.toIntExact(currentLabelId);
        long idRange = NativeLabelScanWriter.rangeOf(nodeId);
        if (labelId != this.key.labelId || idRange != this.key.idRange || this.addition != add) {
            this.flushPendingRange();
            this.key.labelId = labelId;
            this.key.idRange = idRange;
            this.addition = add;
            this.monitor.range(idRange, labelId);
        }
        int offset = Math.toIntExact(nodeId % 64L);
        this.value.set(offset);
        if (this.addition) {
            this.monitor.prepareAdd(txId, offset);
        } else {
            this.monitor.prepareRemove(txId, offset);
        }
    }

    private void flushPendingRange() {
        if (this.value.bits != 0L) {
            if (this.addition) {
                this.writer.merge((Object)this.key, (Object)this.value, this.addMerger);
            } else {
                this.writer.mergeIfExists((Object)this.key, (Object)this.value, this.removeMerger);
            }
            this.value.clear();
        }
    }

    static long rangeOf(long nodeId) {
        return nodeId / 64L;
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushPendingChanges();
            this.monitor.writeSessionEnded();
        }
        finally {
            this.writer.close();
        }
    }

    static interface WriteMonitor {
        default public void range(long range, int labelId) {
        }

        default public void prepareAdd(long txId, int offset) {
        }

        default public void prepareRemove(long txId, int offset) {
        }

        default public void mergeAdd(LabelScanValue existingValue, LabelScanValue newValue) {
        }

        default public void mergeRemove(LabelScanValue existingValue, LabelScanValue newValue) {
        }

        default public void flushPendingUpdates() {
        }

        default public void writeSessionEnded() {
        }

        default public void force() {
        }

        default public void close() {
        }
    }
}

