/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.graphdb.Resource;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.LabelScanValueIndexAccessor;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.kernel.api.index.IndexProgressor;

public class LabelScanValueIndexProgressor
extends LabelScanValueIndexAccessor
implements IndexProgressor,
Resource {
    private final IndexProgressor.NodeLabelClient client;

    LabelScanValueIndexProgressor(Seeker<LabelScanKey, LabelScanValue> cursor, IndexProgressor.NodeLabelClient client) {
        super(cursor);
        this.client = client;
    }

    public boolean next() {
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                if (!this.client.acceptNode(this.baseNodeId + (long)delta, null)) continue;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            LabelScanKey key = (LabelScanKey)this.cursor.key();
            this.baseNodeId = key.idRange * 64L;
            this.bits = ((LabelScanValue)this.cursor.value()).bits;
            if (!$assertionsDisabled && !this.keysInOrder(key)) break;
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        super.close();
        if (this.client instanceof AutoCloseablePlus) {
            ((AutoCloseablePlus)this.client).close();
        }
    }
}

