/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.matcher;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;

public class Neo4jMatchers {
    private Neo4jMatchers() {
    }

    public static <T> Matcher<? super T> inTx(GraphDatabaseService db, Matcher<T> inner) {
        return Neo4jMatchers.inTx(db, inner, false);
    }

    public static <T> Matcher<? super T> inTx(final GraphDatabaseService db, final Matcher<T> inner, final boolean successful) {
        return new DiagnosingMatcher<T>(){

            protected boolean matches(Object item, Description mismatchDescription) {
                try (Transaction tx = db.beginTx();){
                    if (inner instanceof TransactionalMatcher) {
                        ((TransactionalMatcher)inner).setTransaction(tx);
                    }
                    if (inner.matches(item)) {
                        if (successful) {
                            tx.commit();
                        }
                        boolean bl = true;
                        return bl;
                    }
                    inner.describeMismatch(item, mismatchDescription);
                    if (successful) {
                        tx.commit();
                    }
                    boolean bl = false;
                    return bl;
                }
            }

            public void describeTo(Description description) {
                inner.describeTo(description);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabel(Label myLabel) {
        return new LabelMatcher(myLabel);
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(String ... expectedLabels) {
        return Neo4jMatchers.hasLabels(Iterators.asSet((Object[])expectedLabels));
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(Label ... expectedLabels) {
        HashSet<String> labelNames = new HashSet<String>(expectedLabels.length);
        for (Label l : expectedLabels) {
            labelNames.add(l.name());
        }
        return Neo4jMatchers.hasLabels(labelNames);
    }

    public static TypeSafeDiagnosingMatcher<Node> hasNoLabels() {
        return Neo4jMatchers.hasLabels(Collections.emptySet());
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(Set<String> expectedLabels) {
        return new LabelsMatcher(expectedLabels);
    }

    public static TypeSafeDiagnosingMatcher<Transaction> hasNoNodes(final Label withLabel) {
        return new TypeSafeDiagnosingMatcher<Transaction>(){

            protected boolean matchesSafely(Transaction tx, Description mismatchDescription) {
                Set found = Iterators.asSet((Iterator)tx.findNodes(withLabel));
                if (!found.isEmpty()) {
                    mismatchDescription.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("no nodes with label " + withLabel);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Transaction> hasNodes(final Label withLabel, final Node ... expectedNodes) {
        return new TypeSafeDiagnosingMatcher<Transaction>(){

            protected boolean matchesSafely(Transaction tx, Description mismatchDescription) {
                Set found;
                Set expected = Iterators.asSet((Object[])expectedNodes);
                if (!expected.equals(found = Iterators.asSet((Iterator)tx.findNodes(withLabel)))) {
                    mismatchDescription.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(Iterators.asSet((Object[])expectedNodes).toString() + " with label " + withLabel);
            }
        };
    }

    public static Set<String> asLabelNameSet(Iterable<Label> enums) {
        return Iterables.asSet((Iterable)Iterables.map(Label::name, enums));
    }

    public static PropertyMatcher hasProperty(String propertyName) {
        return new PropertyMatcher(propertyName);
    }

    public static Deferred<Node> findNodesByLabelAndProperty(final Label label, final String propertyName, final Object propertyValue, GraphDatabaseService db, final Transaction transaction) {
        return new Deferred<Node>(){

            @Override
            protected Iterable<Node> manifest() {
                return Iterators.loop((Iterator)transaction.findNodes(label, propertyName, propertyValue));
            }
        };
    }

    public static Deferred<IndexDefinition> getIndexes(final Transaction transaction, final Label label) {
        return new Deferred<IndexDefinition>(){

            @Override
            protected Iterable<IndexDefinition> manifest() {
                return transaction.schema().getIndexes(label);
            }
        };
    }

    public static Deferred<String> getPropertyKeys(Transaction transaction, final Entity entity) {
        return new Deferred<String>(){

            @Override
            protected Iterable<String> manifest() {
                return entity.getPropertyKeys();
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final Transaction transaction, final Label label) {
        return new Deferred<ConstraintDefinition>(){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return transaction.schema().getConstraints(label);
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final Transaction transaction, final RelationshipType type) {
        return new Deferred<ConstraintDefinition>(){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return transaction.schema().getConstraints(type);
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final Transaction transaction) {
        return new Deferred<ConstraintDefinition>(){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return transaction.schema().getConstraints();
            }
        };
    }

    @SafeVarargs
    public static <T> TypeSafeDiagnosingMatcher<Deferred<T>> containsOnly(final T ... expectedObjects) {
        return new TypeSafeDiagnosingMatcher<Deferred<T>>(){

            protected boolean matchesSafely(Deferred<T> nodes, Description description) {
                Set found;
                Set expected = Iterators.asSet((Object[])expectedObjects);
                if (!expected.equals(found = Iterables.asSet(nodes.collection()))) {
                    description.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("exactly " + Iterators.asSet((Object[])expectedObjects));
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<?>> hasSize(final int expectedSize) {
        return new TypeSafeDiagnosingMatcher<Deferred<?>>(){

            protected boolean matchesSafely(Deferred<?> nodes, Description description) {
                int foundSize = nodes.collection().size();
                if (foundSize != expectedSize) {
                    description.appendText("found " + nodes.collection().toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("collection of size " + expectedSize);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<IndexDefinition>> haveState(final Transaction transaction, final Schema.IndexState expectedState) {
        return new TypeSafeDiagnosingMatcher<Deferred<IndexDefinition>>(){

            protected boolean matchesSafely(Deferred<IndexDefinition> indexes, Description description) {
                for (IndexDefinition current : indexes.collection()) {
                    Schema.IndexState currentState = transaction.schema().getIndexState(current);
                    if (currentState.equals((Object)expectedState)) continue;
                    description.appendValue((Object)current).appendText(" has state ").appendValue((Object)currentState);
                    if (currentState == Schema.IndexState.FAILED) {
                        String indexFailure = transaction.schema().getIndexFailure(current);
                        description.appendText(" has failure message: ").appendText(indexFailure);
                    }
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("all indexes have state " + expectedState);
            }
        };
    }

    @SafeVarargs
    public static <T> TypeSafeDiagnosingMatcher<Deferred<T>> contains(final T ... expectedObjects) {
        return new TypeSafeDiagnosingMatcher<Deferred<T>>(){

            protected boolean matchesSafely(Deferred<T> nodes, Description description) {
                Set expected = Iterators.asSet((Object[])expectedObjects);
                Set found = Iterables.asSet(nodes.collection());
                if (!found.containsAll(expected)) {
                    description.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("contains " + Iterators.asSet((Object[])expectedObjects));
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<?>> isEmpty() {
        return new TypeSafeDiagnosingMatcher<Deferred<?>>(){

            protected boolean matchesSafely(Deferred<?> deferred, Description description) {
                Collection<?> collection = deferred.collection();
                if (!collection.isEmpty()) {
                    description.appendText("was " + collection.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("empty collection");
            }
        };
    }

    public static IndexDefinition createIndex(GraphDatabaseService beansAPI, Label label, String ... properties) {
        return Neo4jMatchers.createIndex(beansAPI, null, label, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService beansAPI, String name, Label label, String ... properties) {
        IndexDefinition indexDef = Neo4jMatchers.createIndexNoWait(beansAPI, name, label, properties);
        Neo4jMatchers.waitForIndex(beansAPI, indexDef);
        return indexDef;
    }

    public static IndexDefinition createIndexNoWait(GraphDatabaseService beansAPI, Label label, String ... properties) {
        return Neo4jMatchers.createIndexNoWait(beansAPI, null, label, properties);
    }

    public static IndexDefinition createIndexNoWait(GraphDatabaseService db, String name, Label label, String ... properties) {
        IndexDefinition indexDef;
        try (Transaction tx = db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(label);
            for (String property : properties) {
                indexCreator = indexCreator.on(property);
            }
            if (name != null) {
                indexCreator = indexCreator.withName(name);
            }
            indexDef = indexCreator.create();
            tx.commit();
        }
        return indexDef;
    }

    public static void waitForIndex(GraphDatabaseService beansAPI, IndexDefinition indexDef) {
        try (Transaction tx = beansAPI.beginTx();){
            tx.schema().awaitIndexOnline(indexDef, 30L, TimeUnit.SECONDS);
        }
    }

    public static void waitForIndexes(GraphDatabaseService beansAPI) {
        try (Transaction tx = beansAPI.beginTx();){
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
        }
    }

    public static Object getIndexState(Transaction tx, IndexDefinition indexDef) {
        return tx.schema().getIndexState(indexDef);
    }

    public static ConstraintDefinition createConstraint(GraphDatabaseService db, Label label, String propertyKey) {
        try (Transaction tx = db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.commit();
            ConstraintDefinition constraintDefinition = constraint;
            return constraintDefinition;
        }
    }

    public static Collection<Object> arrayAsCollection(Object arrayValue) {
        assert (arrayValue.getClass().isArray());
        ArrayList<Object> result = new ArrayList<Object>();
        int length = Array.getLength(arrayValue);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(arrayValue, i));
        }
        return result;
    }

    private static class LabelsMatcher
    extends TypeSafeDiagnosingMatcher<Node>
    implements TransactionalMatcher {
        private final Set<String> expectedLabels;
        private Transaction transaction;

        LabelsMatcher(Set<String> expectedLabels) {
            this.expectedLabels = expectedLabels;
        }

        public void describeTo(Description description) {
            description.appendText(this.expectedLabels.toString());
        }

        protected boolean matchesSafely(Node item, Description mismatchDescription) {
            Node node = this.transaction.getNodeById(item.getId());
            Set<String> foundLabels = Neo4jMatchers.asLabelNameSet(node.getLabels());
            if (foundLabels.size() == this.expectedLabels.size() && foundLabels.containsAll(this.expectedLabels)) {
                return true;
            }
            mismatchDescription.appendText("was " + foundLabels.toString());
            return false;
        }

        @Override
        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }

    private static class LabelMatcher
    extends TypeSafeDiagnosingMatcher<Node>
    implements TransactionalMatcher {
        private final Label myLabel;
        private Transaction transaction;

        LabelMatcher(Label myLabel) {
            this.myLabel = myLabel;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.myLabel);
        }

        protected boolean matchesSafely(Node item, Description mismatchDescription) {
            Node node = this.transaction.getNodeById(item.getId());
            boolean result = node.hasLabel(this.myLabel);
            if (!result) {
                Set<String> labels = Neo4jMatchers.asLabelNameSet(node.getLabels());
                mismatchDescription.appendText(labels.toString());
            }
            return result;
        }

        @Override
        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }

    @FunctionalInterface
    private static interface TransactionalMatcher {
        public void setTransaction(Transaction var1);
    }

    public static abstract class Deferred<T> {
        protected abstract Iterable<T> manifest();

        public Collection<T> collection() {
            return Iterables.asCollection(this.manifest());
        }
    }

    public static class PropertyMatcher
    extends TypeSafeDiagnosingMatcher<Entity>
    implements TransactionalMatcher {
        public final String propertyName;
        private Transaction transaction;

        private PropertyMatcher(String propertyName) {
            this.propertyName = propertyName;
        }

        protected boolean matchesSafely(Entity entity, Description mismatchDescription) {
            if (this.transaction != null) {
                entity = entity instanceof Node ? this.transaction.getNodeById(entity.getId()) : this.transaction.getRelationshipById(entity.getId());
            }
            if (!entity.hasProperty(this.propertyName)) {
                mismatchDescription.appendText(String.format("found entity with property keys: %s", Iterables.asSet((Iterable)entity.getPropertyKeys())));
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("entity with property name '%s' ", this.propertyName));
        }

        public PropertyValueMatcher withValue(Object value) {
            return new PropertyValueMatcher(this, this.propertyName, value);
        }

        @Override
        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }

    public static class PropertyValueMatcher
    extends TypeSafeDiagnosingMatcher<Entity>
    implements TransactionalMatcher {
        private final PropertyMatcher propertyMatcher;
        private final String propertyName;
        private final Object expectedValue;
        private Transaction transaction;

        private PropertyValueMatcher(PropertyMatcher propertyMatcher, String propertyName, Object expectedValue) {
            this.propertyMatcher = propertyMatcher;
            this.propertyName = propertyName;
            this.expectedValue = expectedValue;
        }

        protected boolean matchesSafely(Entity entity, Description mismatchDescription) {
            Object foundValue;
            if (!this.propertyMatcher.matchesSafely((Entity)entity, mismatchDescription)) {
                return false;
            }
            if (this.transaction != null) {
                entity = entity instanceof Node ? this.transaction.getNodeById(entity.getId()) : this.transaction.getRelationshipById(entity.getId());
            }
            if (!this.propertyValuesEqual(this.expectedValue, foundValue = entity.getProperty(this.propertyName))) {
                mismatchDescription.appendText("found value " + this.formatValue(foundValue));
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            this.propertyMatcher.describeTo(description);
            description.appendText(String.format("having value %s", this.formatValue(this.expectedValue)));
        }

        private boolean propertyValuesEqual(Object expected, Object readValue) {
            if (expected.getClass().isArray()) {
                return Neo4jMatchers.arrayAsCollection(expected).equals(Neo4jMatchers.arrayAsCollection(readValue));
            }
            return expected.equals(readValue);
        }

        private String formatValue(Object v) {
            if (v instanceof String) {
                return String.format("'%s'", v.toString());
            }
            return v.toString();
        }

        @Override
        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
            this.propertyMatcher.setTransaction(transaction);
        }
    }
}

