/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class StubStorageCursors
implements StorageReader {
    private static final long NO_ID = -1L;
    private final AtomicLong nextPropertyId = new AtomicLong();
    private final AtomicLong nextTokenId = new AtomicLong();
    private final TokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder((name, internal) -> Math.toIntExact(this.nextTokenId.getAndIncrement()), "PropertyKey");
    private final Map<Long, NodeData> nodeData = new HashMap<Long, NodeData>();
    private final Map<String, Long> labelByName = new HashMap<String, Long>();
    private final Map<Long, String> labelById = new HashMap<Long, String>();
    private final Map<String, Long> propertyKeyByName = new HashMap<String, Long>();
    private final Map<Long, String> propertyKeyById = new HashMap<Long, String>();
    private final Map<String, Long> relationshipTypeByName = new HashMap<String, Long>();
    private final Map<Long, String> relationshipTypeById = new HashMap<Long, String>();
    private final Map<Long, PropertyData> propertyData = new HashMap<Long, PropertyData>();
    private final Map<Long, RelationshipData> relationshipData = new HashMap<Long, RelationshipData>();

    public NodeData withNode(long id) {
        NodeData node = new NodeData(id);
        this.nodeData.put(id, node);
        return node;
    }

    public RelationshipData withRelationship(long id, long startNode, int type, long endNode) {
        RelationshipData data = new RelationshipData(id, startNode, type, endNode);
        this.relationshipData.put(id, data);
        return data;
    }

    private long propertyIdOf(Map<String, Value> properties) {
        if (properties.isEmpty()) {
            return -1L;
        }
        long propertyId = this.nextPropertyId.incrementAndGet();
        this.propertyData.put(propertyId, new PropertyData(properties));
        for (String key : properties.keySet()) {
            this.silentGetOrCreatePropertyKey(key);
        }
        return propertyId;
    }

    private int silentGetOrCreatePropertyKey(String key) {
        try {
            return this.propertyKeyTokenHolder.getOrCreateId(key);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    public TokenHolder propertyKeyTokenHolder() {
        return this.propertyKeyTokenHolder;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IndexDescriptor indexGetForName(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean indexExists(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexDescriptor> indexesGetRelated(long[] labels, int propertyKeyId, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexDescriptor> indexesGetRelated(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] labels, int propertyKeyId, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean hasRelatedSchema(long[] labels, int propertyKey, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean hasRelatedSchema(int label, EntityType entityType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long countsForNode(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long nodesGetCount() {
        return this.nodeData.size();
    }

    public long relationshipsGetCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int labelCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int propertyKeyCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int relationshipTypeCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean nodeExists(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean relationshipExists(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AllNodeScan allNodeScan() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public AllRelationshipsScan allRelationshipScan() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public StorageNodeCursor allocateNodeCursor() {
        return new StubStorageNodeCursor();
    }

    public StoragePropertyCursor allocatePropertyCursor() {
        return new StubStoragePropertyCursor();
    }

    public StorageRelationshipGroupCursor allocateRelationshipGroupCursor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public StorageRelationshipScanCursor allocateRelationshipScanCursor() {
        return new StubStorageRelationshipScanCursor();
    }

    public StorageSchemaReader schemaSnapshot() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class StubStoragePropertyCursor
    implements StoragePropertyCursor {
        private Map.Entry<String, Value> current;
        private Iterator<Map.Entry<String, Value>> iterator;

        private StubStoragePropertyCursor() {
        }

        public void initNodeProperties(long reference) {
            this.init(reference);
        }

        public void initRelationshipProperties(long reference) {
            this.init(reference);
        }

        private void init(long reference) {
            PropertyData properties = StubStorageCursors.this.propertyData.get(reference);
            this.iterator = properties != null ? properties.properties.entrySet().iterator() : Collections.emptyIterator();
        }

        public void close() {
        }

        public int propertyKey() {
            return StubStorageCursors.this.silentGetOrCreatePropertyKey(this.current.getKey());
        }

        public ValueGroup propertyType() {
            return this.current.getValue().valueGroup();
        }

        public Value propertyValue() {
            return this.current.getValue();
        }

        public void reset() {
        }

        public boolean next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }
    }

    private class StubStorageRelationshipScanCursor
    implements StorageRelationshipScanCursor {
        private Iterator<Long> iterator;
        private RelationshipData current;
        private long next;

        private StubStorageRelationshipScanCursor() {
        }

        public void scan() {
            this.scan(-1);
        }

        public void scan(int type) {
            this.iterator = StubStorageCursors.this.relationshipData.keySet().iterator();
            this.next = -1L;
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public boolean scanBatch(AllRelationshipsScan scan, int sizeHint) {
            throw new UnsupportedOperationException();
        }

        public long entityReference() {
            return this.current.id;
        }

        public int type() {
            return this.current.type;
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public long sourceNodeReference() {
            return this.current.startNode;
        }

        public long targetNodeReference() {
            return this.current.endNode;
        }

        public long propertiesReference() {
            return this.current.propertyId;
        }

        public void properties(StoragePropertyCursor propertyCursor) {
            propertyCursor.initRelationshipProperties(this.propertiesReference());
        }

        public boolean next() {
            if (this.iterator != null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.next = this.iterator.next();
            }
            if (this.next != -1L) {
                this.current = StubStorageCursors.this.relationshipData.get(this.next);
                this.next = -1L;
                return true;
            }
            return false;
        }

        public void reset() {
            this.current = null;
            this.next = -1L;
        }

        public void close() {
            this.reset();
        }
    }

    private class StubStorageNodeCursor
    implements StorageNodeCursor {
        private long next;
        private NodeData current;
        private Iterator<Long> iterator;

        private StubStorageNodeCursor() {
        }

        public void scan() {
            this.iterator = StubStorageCursors.this.nodeData.keySet().iterator();
            this.current = null;
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public boolean scanBatch(AllNodeScan scan, int sizeHint) {
            throw new UnsupportedOperationException();
        }

        public long entityReference() {
            return this.current.id;
        }

        public long[] labels() {
            return this.current.labels;
        }

        public boolean hasLabel(int label) {
            return ArrayUtils.contains((long[])this.current.labels, (long)label);
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public long relationshipGroupReference() {
            return this.current.firstRelationship;
        }

        public long allRelationshipsReference() {
            return this.current.firstRelationship;
        }

        public long propertiesReference() {
            return this.current.propertyId;
        }

        public void properties(StoragePropertyCursor propertyCursor) {
            propertyCursor.initNodeProperties(this.propertiesReference());
        }

        public boolean next() {
            if (this.iterator != null) {
                while (this.iterator.hasNext()) {
                    this.current = StubStorageCursors.this.nodeData.get(this.iterator.next());
                    if (!this.current.inUse) continue;
                    return true;
                }
                this.current = null;
                return false;
            }
            if (this.next != -1L) {
                this.current = StubStorageCursors.this.nodeData.get(this.next);
                this.next = -1L;
                return this.current != null && this.current.inUse;
            }
            return false;
        }

        public void reset() {
            this.iterator = null;
            this.current = null;
        }

        public boolean isDense() {
            return false;
        }

        public void close() {
            this.reset();
        }
    }

    private static class PropertyData {
        private final Map<String, Value> properties;

        PropertyData(Map<String, Value> properties) {
            this.properties = properties;
        }
    }

    public class RelationshipData
    extends EntityData<RelationshipData> {
        private final long id;
        private final long startNode;
        private final int type;
        private final long endNode;

        RelationshipData(long id, long startNode, int type, long endNode) {
            this.id = id;
            this.startNode = startNode;
            this.type = type;
            this.endNode = endNode;
        }
    }

    public class NodeData
    extends EntityData<NodeData> {
        private final long id;
        private long[] labels;
        private long firstRelationship;

        NodeData(long id) {
            this.labels = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
            this.firstRelationship = -1L;
            this.id = id;
        }

        public NodeData labels(long ... labels) {
            this.labels = labels;
            return this;
        }

        public NodeData relationship(long firstRelationship) {
            this.firstRelationship = firstRelationship;
            return this;
        }
    }

    class EntityData<SELF>
    extends Data<SELF> {
        long propertyId;

        EntityData() {
            this.propertyId = -1L;
        }

        public SELF propertyId(long propertyId) {
            this.propertyId = propertyId;
            return (SELF)this;
        }

        public SELF properties(Map<String, Value> properties) {
            return this.propertyId(StubStorageCursors.this.propertyIdOf(properties));
        }

        public SELF properties(Object ... properties) {
            return this.properties(MapUtil.genericMap((Object[])properties));
        }
    }

    public class Data<SELF> {
        boolean inUse = true;

        public SELF inUse(boolean inUse) {
            this.inUse = inUse;
            return (SELF)this;
        }
    }
}

