/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.io.File;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class TestEphemeralFileChannel {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;

    TestEphemeralFileChannel() {
    }

    @Test
    void smoke() throws Exception {
        StoreChannel channel = this.fileSystem.write(new File("yo"));
        ByteBuffer buffer = ByteBuffers.allocate((int)23);
        buffer.put(new byte[23]);
        buffer.flip();
        channel.write(buffer);
        channel = this.fileSystem.write(new File("yo"));
        long longValue = 1234567890L;
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)1);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)2);
        buffer.flip();
        channel.position(6L);
        channel.write(buffer);
        buffer.clear();
        buffer.limit(8);
        buffer.putLong(longValue);
        buffer.flip();
        channel.position(15L);
        channel.write(buffer);
        Assertions.assertEquals((long)23L, (long)channel.size());
        buffer.clear();
        buffer.limit(1);
        channel.read(buffer, 0L);
        buffer.flip();
        Assertions.assertEquals((byte)1, (byte)buffer.get());
        buffer.clear();
        buffer.limit(3);
        channel.read(buffer, 5L);
        buffer.flip();
        Assertions.assertEquals((byte)0, (byte)buffer.get());
        Assertions.assertEquals((byte)2, (byte)buffer.get());
        Assertions.assertEquals((byte)0, (byte)buffer.get());
        buffer.clear();
        buffer.limit(8);
        channel.read(buffer, 15L);
        buffer.flip();
        Assertions.assertEquals((long)longValue, (long)buffer.getLong());
    }

    @Test
    void absoluteVersusRelative() throws Exception {
        File file = new File("myfile");
        StoreChannel channel = this.fileSystem.write(file);
        byte[] bytes = "test".getBytes();
        channel.write(ByteBuffer.wrap(bytes));
        channel.close();
        channel = this.fileSystem.read(new File(file.getAbsolutePath()));
        byte[] readBytes = new byte[bytes.length];
        channel.readAll(ByteBuffer.wrap(readBytes));
        Assertions.assertArrayEquals((byte[])bytes, (byte[])readBytes);
    }

    @Test
    void listFiles() throws Exception {
        File root = new File("/root").getCanonicalFile();
        File dir1 = new File(root, "dir1");
        File dir2 = new File(root, "dir2");
        File subdir1 = new File(dir1, "sub");
        File file1 = new File(dir1, "file");
        File file2 = new File(dir1, "file2");
        File file3 = new File(dir2, "file");
        File file4 = new File(subdir1, "file");
        this.fileSystem.mkdirs(dir2);
        this.fileSystem.mkdirs(dir1);
        this.fileSystem.mkdirs(subdir1);
        this.fileSystem.write(file1);
        this.fileSystem.write(file2);
        this.fileSystem.write(file3);
        this.fileSystem.write(file4);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new File[]{dir1, dir2}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(root)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new File[]{subdir1, file1, file2}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(dir1)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new File[]{file3}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(dir2)));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new File[]{file4}), (Object)Iterators.asSet((Object[])this.fileSystem.listFiles(subdir1)));
    }
}

