/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;

@EphemeralPageCacheExtension
@EphemeralNeo4jLayoutExtension
class LogTailScannerTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private final LogEntryReader reader = TestLogEntryReader.logEntryReader();
    private LogTailScanner tailScanner;
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private final LogEntryVersion latestLogEntryVersion = LogEntryVersion.LATEST_VERSION;
    private LogVersionRepository logVersionRepository;
    private TransactionIdStore transactionIdStore;

    LogTailScannerTest() {
    }

    private static Stream<Arguments> params() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{1, 2}), Arguments.arguments((Object[])new Object[]{42, 43}));
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logVersionRepository = new SimpleLogVersionRepository();
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withLogVersionRepository(this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.tailScanner = new LogTailScanner(this.logFiles, this.reader, this.monitors);
    }

    @Test
    void detectMissingLogFiles() {
        LogTailScanner.LogTailInformation tailInformation = this.tailScanner.getTailInformation();
        Assertions.assertTrue((boolean)tailInformation.logsMissing());
        Assertions.assertTrue((boolean)tailInformation.isRecoveryRequired());
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void noLogFilesFound(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, new LogCreator[0]);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, false, -1L, -1L, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void oneLogFileNoCheckPoints(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, false, -1L, endLogVersion, logTailInformation);
        Assertions.assertFalse((boolean)logTailInformation.logsMissing());
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void oneLogFileNoCheckPointsOneStart(int startLogVersion, int endLogVersion) {
        long txId = 10L;
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, true, txId, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPoints(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, false, -1L, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsOneStart(int startLogVersion, int endLogVersion) {
        long txId = 21L;
        this.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, true, txId, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsOneStartWithoutCommit(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, true, -1L, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesNoCheckPointsTwoCommits(int startLogVersion, int endLogVersion) {
        long txId = 21L;
        this.setupLogFiles(endLogVersion, this.logFile(new Entry[0]), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId), LogTailScannerTest.start(), LogTailScannerTest.commit(txId + 1L)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, true, txId, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesCheckPointTargetsPrevious(int startLogVersion, int endLogVersion) {
        long txId = 6L;
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId - 1L), position), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesStartAndCommitInDifferentFiles(int startLogVersion, int endLogVersion) {
        long txId = 6L;
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start()), this.logFile(LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(false, true, 6L, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointOnly(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointAndAStartBefore(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(1L), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void bigFileLatestCheckpointFindsStartAfter(int startLogVersion, int endLogVersion) throws IOException {
        long firstTxAfterCheckpoint = 0x80000003L;
        FirstTxIdConfigurableTailScanner tailScanner = new FirstTxIdConfigurableTailScanner(firstTxAfterCheckpoint, this.logFiles, this.reader, this.monitors);
        LogEntryStart startEntry = new LogEntryStart(3L, 4L, 0, new byte[]{5, 6}, new LogPosition((long)endLogVersion, 0x80000010L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)endLogVersion, 16L));
        LogTailScanner.LogTailInformation logTailInformation = tailScanner.checkpointTailInformation(endLogVersion, startEntry, endLogVersion, this.latestLogEntryVersion, checkPoint, false, StoreId.UNKNOWN);
        LogTailScannerTest.assertLatestCheckPoint(true, true, firstTxAfterCheckpoint, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesSecondIsCorruptedBeforeCommit(int startLogVersion, int endLogVersion) throws IOException {
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint()), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(2L)));
        File highestLogFile = this.logFiles.getHighestLogFile();
        this.fs.truncate(highestLogFile, this.fs.getFileSize(highestLogFile) - 3L);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, -1L, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void twoLogFilesSecondIsCorruptedBeforeAfterCommit(int startLogVersion, int endLogVersion) throws IOException {
        int firstTxId = 2;
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint()), this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(firstTxId), LogTailScannerTest.start(), LogTailScannerTest.commit(3L)));
        File highestLogFile = this.logFiles.getHighestLogFile();
        this.fs.truncate(highestLogFile, this.fs.getFileSize(highestLogFile) - 3L);
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, firstTxId, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingACheckPointAndAStartAfter(int startLogVersion, int endLogVersion) {
        long txId = 35L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(endLogVersion, this.logFile(start, LogTailScannerTest.commit(txId), LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingMultipleCheckPointsOneStartInBetween(int startLogVersion, int endLogVersion) {
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(1L), LogTailScannerTest.checkPoint()));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth(int startLogVersion, int endLogVersion) {
        long txId = 11L;
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint(), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingACheckPointAndNewerFileContainingAStart(int startLogVersion, int endLogVersion) {
        long txId = 11L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.checkPoint()), this.logFile(start, LogTailScannerTest.commit(txId)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingACheckPointAndNewerFileIsEmpty(int startLogVersion, int endLogVersion) {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(endLogVersion, this.logFile(start, LogTailScannerTest.commit(1L), LogTailScannerTest.checkPoint()), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, startLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart(int startLogVersion, int endLogVersion) {
        long txId = 123L;
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(endLogVersion, this.logFile(start, LogTailScannerTest.commit(txId)), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStartWithoutCommit(int startLogVersion, int endLogVersion) {
        StartEntry start = LogTailScannerTest.start();
        this.setupLogFiles(endLogVersion, this.logFile(start), this.logFile(LogTailScannerTest.checkPoint(start)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart(int startLogVersion, int endLogVersion) {
        PositionEntry position = LogTailScannerTest.position();
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(3L), position), this.logFile(LogTailScannerTest.checkPoint(position)));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, false, -1L, endLogVersion, logTailInformation);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog(int startLogVersion, int endLogVersion) {
        long txId = 432L;
        this.setupLogFiles(endLogVersion, this.logFile(LogTailScannerTest.start(), LogTailScannerTest.commit(1L), LogTailScannerTest.checkPoint(), LogTailScannerTest.start(), LogTailScannerTest.commit(txId)), this.logFile(new Entry[0]));
        LogTailScanner.LogTailInformation logTailInformation = this.tailScanner.getTailInformation();
        LogTailScannerTest.assertLatestCheckPoint(true, true, txId, startLogVersion, logTailInformation);
    }

    private void setupLogFiles(long endLogVersion, LogCreator ... logFiles) {
        HashMap<Entry, LogPosition> positions = new HashMap<Entry, LogPosition>();
        long version = endLogVersion - (long)logFiles.length;
        for (LogCreator logFile : logFiles) {
            logFile.create(++version, positions);
        }
    }

    private LogCreator logFile(Entry ... entries) {
        return (logVersion, positions) -> {
            try {
                AtomicLong lastTxId = new AtomicLong();
                this.logVersionRepository.setCurrentLogVersion(logVersion);
                LifeSupport logFileLife = new LifeSupport();
                logFileLife.start();
                logFileLife.add((Lifecycle)this.logFiles);
                LogFile logFile = this.logFiles.getLogFile();
                int previousChecksum = -559063315;
                try {
                    FlushablePositionAwareChecksumChannel writeChannel = logFile.getWriter();
                    LogPositionMarker positionMarker = new LogPositionMarker();
                    LogEntryWriter writer = new LogEntryWriter((WritableChecksumChannel)writeChannel);
                    for (Entry entry : entries) {
                        LogPosition currentPosition = writeChannel.getCurrentPosition(positionMarker).newPosition();
                        positions.put(entry, currentPosition);
                        if (entry instanceof StartEntry) {
                            writer.writeStartEntry(0L, 0L, previousChecksum, new byte[0]);
                            continue;
                        }
                        if (entry instanceof CommitEntry) {
                            CommitEntry commitEntry = (CommitEntry)entry;
                            previousChecksum = writer.writeCommitEntry(commitEntry.txId, 0L);
                            lastTxId.set(commitEntry.txId);
                            continue;
                        }
                        if (entry instanceof CheckPointEntry) {
                            LogPosition logPosition;
                            CheckPointEntry checkPointEntry = (CheckPointEntry)entry;
                            Entry target = checkPointEntry.withPositionOfEntry;
                            LogPosition logPosition2 = logPosition = target != null ? (LogPosition)positions.get(target) : currentPosition;
                            assert (logPosition != null) : "No registered log position for " + target;
                            writer.writeCheckPointEntry(logPosition);
                            continue;
                        }
                        if (entry instanceof PositionEntry) continue;
                        throw new IllegalArgumentException("Unknown entry " + entry);
                    }
                }
                finally {
                    logFileLife.shutdown();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static StartEntry start() {
        return new StartEntry();
    }

    private static CommitEntry commit(long txId) {
        return new CommitEntry(txId);
    }

    private static CheckPointEntry checkPoint() {
        return LogTailScannerTest.checkPoint(null);
    }

    private static CheckPointEntry checkPoint(Entry forEntry) {
        return new CheckPointEntry(forEntry);
    }

    private static PositionEntry position() {
        return new PositionEntry();
    }

    private static void assertLatestCheckPoint(boolean hasCheckPointEntry, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, long logVersion, LogTailScanner.LogTailInformation logTailInformation) {
        Assertions.assertEquals((Object)hasCheckPointEntry, (Object)(logTailInformation.lastCheckPoint != null ? 1 : 0));
        Assertions.assertEquals((Object)commitsAfterLastCheckPoint, (Object)logTailInformation.commitsAfterLastCheckpoint());
        if (commitsAfterLastCheckPoint) {
            Assertions.assertEquals((long)firstTxIdAfterLastCheckPoint, (long)logTailInformation.firstTxIdAfterLastCheckPoint);
        }
        Assertions.assertEquals((long)logVersion, (long)logTailInformation.oldestLogVersionFound);
    }

    private static class FirstTxIdConfigurableTailScanner
    extends LogTailScanner {
        private final long txId;

        FirstTxIdConfigurableTailScanner(long txId, LogFiles logFiles, LogEntryReader logEntryReader, Monitors monitors) {
            super(logFiles, logEntryReader, monitors);
            this.txId = txId;
        }

        protected LogTailScanner.ExtractedTransactionRecord extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) {
            return new LogTailScanner.ExtractedTransactionRecord(this.txId);
        }
    }

    private static class PositionEntry
    implements Entry {
        private PositionEntry() {
        }
    }

    private static class CheckPointEntry
    implements Entry {
        final Entry withPositionOfEntry;

        CheckPointEntry(Entry withPositionOfEntry) {
            this.withPositionOfEntry = withPositionOfEntry;
        }
    }

    private static class CommitEntry
    implements Entry {
        final long txId;

        CommitEntry(long txId) {
            this.txId = txId;
        }
    }

    private static class StartEntry
    implements Entry {
        private StartEntry() {
        }
    }

    static interface Entry {
    }

    @FunctionalInterface
    static interface LogCreator {
        public void create(long var1, Map<Entry, LogPosition> var3);
    }
}

