/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class CorruptedLogsTruncatorTest {
    private static final long SINGLE_LOG_FILE_SIZE = 73L;
    private static final int TOTAL_NUMBER_OF_LOG_FILES = 12;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private final LifeSupport life = new LifeSupport();
    private File databaseDirectory;
    private LogFiles logFiles;
    private CorruptedLogsTruncator logPruner;

    CorruptedLogsTruncatorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.databaseDirectory = this.testDirectory.homeDir();
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        this.logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseDirectory, (FileSystemAbstraction)this.fs).withRotationThreshold(73L).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)this.logFiles);
        this.logPruner = new CorruptedLogsTruncator(this.databaseDirectory, this.logFiles, this.fs);
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
    }

    @Test
    void doNotPruneEmptyLogs() throws IOException {
        this.logPruner.truncate(new LogPosition(0L, 64L));
        Assertions.assertTrue((boolean)FileSystemUtils.isEmptyOrNonExistingDirectory((FileSystemAbstraction)this.fs, (File)this.databaseDirectory));
    }

    @Test
    void doNotPruneNonCorruptedLogs() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestLogVersion = this.logFiles.getHighestLogVersion();
        long fileSizeBeforePrune = this.logFiles.getHighestLogFile().length();
        LogPosition endOfLogsPosition = new LogPosition(highestLogVersion, fileSizeBeforePrune);
        Assertions.assertEquals((long)11L, (long)highestLogVersion);
        this.logPruner.truncate(endOfLogsPosition);
        Assertions.assertEquals((int)12, (int)this.logFiles.logFiles().length);
        Assertions.assertEquals((long)fileSizeBeforePrune, (long)this.logFiles.getHighestLogFile().length());
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((Object[])this.databaseDirectory.listFiles(File::isDirectory)));
    }

    @Test
    void pruneAndArchiveLastLog() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestLogVersion = this.logFiles.getHighestLogVersion();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long fileSizeBeforePrune = highestLogFile.length();
        int bytesToPrune = 5;
        long byteOffset = fileSizeBeforePrune - (long)bytesToPrune;
        LogPosition prunePosition = new LogPosition(highestLogVersion, byteOffset);
        this.logPruner.truncate(prunePosition);
        Assertions.assertEquals((int)12, (int)this.logFiles.logFiles().length);
        Assertions.assertEquals((long)byteOffset, (long)highestLogFile.length());
        File corruptedLogsDirectory = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        Assertions.assertTrue((boolean)corruptedLogsDirectory.exists());
        File[] files = corruptedLogsDirectory.listFiles();
        Assertions.assertNotNull((Object)files);
        Assertions.assertEquals((int)1, (int)files.length);
        File corruptedLogsArchive = files[0];
        this.checkArchiveName(highestLogVersion, byteOffset, corruptedLogsArchive);
        try (ZipFile zipFile = new ZipFile(corruptedLogsArchive);){
            Assertions.assertEquals((int)1, (int)zipFile.size());
            this.checkEntryNameAndSize(zipFile, highestLogFile.getName(), bytesToPrune);
        }
    }

    @Test
    void pruneAndArchiveMultipleLogs() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestCorrectLogFileIndex = 5L;
        File highestCorrectLogFile = this.logFiles.getLogFileForVersion(highestCorrectLogFileIndex);
        long fileSizeBeforePrune = highestCorrectLogFile.length();
        long highestLogFileLength = this.logFiles.getHighestLogFile().length();
        int bytesToPrune = 7;
        long byteOffset = fileSizeBeforePrune - (long)bytesToPrune;
        LogPosition prunePosition = new LogPosition(highestCorrectLogFileIndex, byteOffset);
        this.life.shutdown();
        this.logPruner.truncate(prunePosition);
        this.life.start();
        Assertions.assertEquals((int)6, (int)this.logFiles.logFiles().length);
        Assertions.assertEquals((long)byteOffset, (long)highestCorrectLogFile.length());
        File corruptedLogsDirectory = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        Assertions.assertTrue((boolean)corruptedLogsDirectory.exists());
        File[] files = corruptedLogsDirectory.listFiles();
        Assertions.assertNotNull((Object)files);
        Assertions.assertEquals((int)1, (int)files.length);
        File corruptedLogsArchive = files[0];
        this.checkArchiveName(highestCorrectLogFileIndex, byteOffset, corruptedLogsArchive);
        try (ZipFile zipFile = new ZipFile(corruptedLogsArchive);){
            Assertions.assertEquals((int)7, (int)zipFile.size());
            this.checkEntryNameAndSize(zipFile, highestCorrectLogFile.getName(), bytesToPrune);
            long nextLogFileIndex = highestCorrectLogFileIndex + 1L;
            int lastFileIndex = 11;
            for (long index = nextLogFileIndex; index < (long)lastFileIndex; ++index) {
                this.checkEntryNameAndSize(zipFile, "neostore.transaction.db." + index, 73L);
            }
            this.checkEntryNameAndSize(zipFile, "neostore.transaction.db." + lastFileIndex, highestLogFileLength);
        }
    }

    private void checkEntryNameAndSize(ZipFile zipFile, String entryName, long expectedSize) throws IOException {
        ZipEntry entry = zipFile.getEntry(entryName);
        InputStream inputStream = zipFile.getInputStream(entry);
        int entryBytes = 0;
        while (inputStream.read() >= 0) {
            ++entryBytes;
        }
        Assertions.assertEquals((long)expectedSize, (long)entryBytes);
    }

    private void checkArchiveName(long highestLogVersion, long byteOffset, File corruptedLogsArchive) {
        String name = corruptedLogsArchive.getName();
        Assertions.assertTrue((boolean)name.startsWith("corrupted-neostore.transaction.db-" + highestLogVersion + "-" + byteOffset));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)name, (String)"zip"));
    }

    private void generateTransactionLogFiles(LogFiles logFiles) throws IOException {
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
        for (byte i = 0; i < 107; i = (byte)(i + 1)) {
            writer.put(i);
            writer.prepareForFlush();
            if (!logFile.rotationNeeded()) continue;
            logFile.rotate();
        }
    }
}

