/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.kernel.impl.api.tracer.DefaultTracer;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

class TracersTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final SystemNanoClock clock = Clocks.nanoClock();
    private final Monitors monitors = new Monitors();
    private Log log;

    TracersTest() {
    }

    @BeforeEach
    void setUp() {
        this.log = this.logProvider.getLog(this.getClass());
    }

    @Test
    void mustProduceNullImplementationsWhenRequested() {
        Tracers tracers = this.createTracers("null");
        MatcherAssert.assertThat((Object)tracers.getPageCacheTracer(), (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        MatcherAssert.assertThat((Object)tracers.getPageCursorTracerSupplier(), (Matcher)Matchers.is((Object)PageCursorTracerSupplier.NULL));
        MatcherAssert.assertThat((Object)tracers.getDatabaseTracer(), (Matcher)Matchers.is((Object)DatabaseTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationForNullConfiguration() {
        Tracers tracers = this.createTracers(null);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationWhenRequested() {
        Tracers tracers = this.createTracers("default");
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationWhenRequestingUnknownImplementation() {
        Tracers tracers = this.createTracers("there's nothing like this");
        this.assertDefaultImplementation(tracers);
        this.assertWarning("there's nothing like this");
    }

    private Tracers createTracers(String s) {
        return new Tracers(s, this.log, this.monitors, this.jobScheduler, this.clock);
    }

    private void assertDefaultImplementation(Tracers tracers) {
        MatcherAssert.assertThat((Object)tracers.getPageCacheTracer(), (Matcher)Matchers.instanceOf(DefaultPageCacheTracer.class));
        MatcherAssert.assertThat((Object)tracers.getDatabaseTracer(), (Matcher)Matchers.instanceOf(DefaultTracer.class));
        MatcherAssert.assertThat((Object)tracers.getPageCursorTracerSupplier(), (Matcher)Matchers.instanceOf(DefaultPageCursorTracerSupplier.class));
    }

    private void assertNoWarning() {
        this.logProvider.assertNoLoggingOccurred();
    }

    private void assertWarning(String implementationName) {
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).warn("Using default tracer implementations instead of '%s'", new Object[]{implementationName})});
    }
}

