/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;

class JVMCheckerTest {
    JVMCheckerTest() {
    }

    @Test
    void shouldIssueWarningWhenUsingHotspotServerVmVersion12() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "12")).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."));
    }

    @Test
    void shouldNotIssueWarningWhenUsingHotspotServerVmVersion11() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11")).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11.")));
    }

    @Test
    void shouldIssueWarningWhenUsingUnsupportedJvmVersion() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "22.33.44.55")).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."));
    }

    @Test
    void warnAboutMissingInitialHeapSize() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2+9", Collections.singletonList("-XMx"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.initialHeapSize, (long)12L)));
    }

    @Test
    void warnAboutMissingMaximumHeapSize() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11", Collections.singletonList("-XMs"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.maxHeapSize, (long)23L)));
    }

    @Test
    void warnAboutMissingHeapSizes() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.1")).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.initialHeapSize, (long)1L)));
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.maxHeapSize, (long)2L)));
    }

    @Test
    void doNotWarnAboutMissingHeapSizesWhenOptionsSpecified() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2", Arrays.asList("-xMx", "-xmS"), 1L, 2L)).checkJvmCompatibilityAndIssueWarning();
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.initialHeapSize, (long)1L))));
        MatcherAssert.assertThat((Object)bufferingLogger.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)JvmChecker.memorySettingWarning((Setting)ExternalSettings.maxHeapSize, (long)2L))));
    }
}

