/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;

class SimpleBitSetTest {
    SimpleBitSetTest() {
    }

    @Test
    void put() {
        SimpleBitSet set = new SimpleBitSet(16);
        set.put(2);
        set.put(7);
        set.put(15);
        Assertions.assertFalse((boolean)set.contains(1));
        Assertions.assertFalse((boolean)set.contains(6));
        Assertions.assertFalse((boolean)set.contains(14));
        Assertions.assertTrue((boolean)set.contains(2));
        Assertions.assertTrue((boolean)set.contains(7));
        Assertions.assertTrue((boolean)set.contains(15));
    }

    @Test
    void putAndRemove() {
        SimpleBitSet set = new SimpleBitSet(16);
        set.put(2);
        set.put(7);
        set.remove(2);
        Assertions.assertFalse((boolean)set.contains(1));
        Assertions.assertFalse((boolean)set.contains(6));
        Assertions.assertFalse((boolean)set.contains(14));
        Assertions.assertFalse((boolean)set.contains(2));
        Assertions.assertTrue((boolean)set.contains(7));
    }

    @Test
    void putOtherBitSet() {
        SimpleBitSet set = new SimpleBitSet(16);
        SimpleBitSet otherSet = new SimpleBitSet(16);
        otherSet.put(4);
        otherSet.put(14);
        set.put(3);
        set.put(4);
        set.put(otherSet);
        Assertions.assertFalse((boolean)set.contains(0));
        Assertions.assertFalse((boolean)set.contains(1));
        Assertions.assertFalse((boolean)set.contains(15));
        Assertions.assertFalse((boolean)set.contains(7));
        Assertions.assertTrue((boolean)set.contains(3));
        Assertions.assertTrue((boolean)set.contains(4));
        Assertions.assertTrue((boolean)set.contains(14));
    }

    @Test
    void removeOtherBitSet() {
        SimpleBitSet set = new SimpleBitSet(16);
        SimpleBitSet otherSet = new SimpleBitSet(16);
        otherSet.put(4);
        otherSet.put(12);
        otherSet.put(14);
        set.put(3);
        set.put(4);
        set.put(12);
        set.remove(otherSet);
        Assertions.assertFalse((boolean)set.contains(0));
        Assertions.assertFalse((boolean)set.contains(1));
        Assertions.assertFalse((boolean)set.contains(4));
        Assertions.assertFalse((boolean)set.contains(14));
        Assertions.assertTrue((boolean)set.contains(3));
    }

    @Test
    void resize() {
        SimpleBitSet set = new SimpleBitSet(8);
        set.put(128);
        Assertions.assertTrue((boolean)set.contains(128));
        Assertions.assertFalse((boolean)set.contains(126));
        Assertions.assertFalse((boolean)set.contains(129));
    }

    @Test
    void shouldAllowIterating() {
        SimpleBitSet set = new SimpleBitSet(64);
        set.put(4);
        set.put(7);
        set.put(63);
        set.put(78);
        IntIterator iterator = set.iterator();
        IntArrayList found = new IntArrayList();
        while (iterator.hasNext()) {
            found.add(iterator.next());
        }
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.equalTo((Object)IntLists.immutable.of(new int[]{4, 7, 63, 78})));
    }

    @Test
    void checkPointOnUnchangedSetMustDoNothing() {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        MatcherAssert.assertThat((Object)set.checkPointAndPut(checkpoint, key), (Matcher)Matchers.is((Object)checkpoint));
        Assertions.assertTrue((boolean)set.contains(key));
    }

    @Test
    void checkPointOnUnchangedSetButWithDifferentKeyMustUpdateSet() {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        MatcherAssert.assertThat((Object)set.checkPointAndPut(checkpoint, key + 1), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        Assertions.assertTrue((boolean)set.contains(key + 1));
        Assertions.assertFalse((boolean)set.contains(key));
    }

    @Test
    void checkPointOnChangedSetMustClearState() {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        set.put(key + 1);
        MatcherAssert.assertThat((Object)set.checkPointAndPut(checkpoint, key), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        Assertions.assertTrue((boolean)set.contains(key));
        Assertions.assertFalse((boolean)set.contains(key + 1));
    }

    @Test
    void checkPointMustBeAbleToExpandCapacity() {
        SimpleBitSet set = new SimpleBitSet(16);
        int key = 10;
        int key2 = 255;
        set.put(key);
        long checkpoint = 0L;
        checkpoint = set.checkPointAndPut(checkpoint, key);
        MatcherAssert.assertThat((Object)set.checkPointAndPut(checkpoint, key2), (Matcher)Matchers.is((Matcher)Matchers.not((Object)checkpoint)));
        Assertions.assertTrue((boolean)set.contains(key2));
        Assertions.assertFalse((boolean)set.contains(key));
    }

    @Test
    void modificationsMustTakeWriteLocks() {
        SimpleBitSet set = new SimpleBitSet(16);
        long stamp = set.tryOptimisticRead();
        set.put(8);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.put(8);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        SimpleBitSet other = new SimpleBitSet(16);
        other.put(3);
        set.put(other);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.remove(3);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        set.remove(3);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        other.put(8);
        set.remove(other);
        Assertions.assertFalse((boolean)set.validate(stamp));
        stamp = set.tryOptimisticRead();
        other.put(8);
        set.remove(other);
        Assertions.assertFalse((boolean)set.validate(stamp));
    }
}

