/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.AllEntriesLabelScanReader;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class DynamicIndexStoreViewTest {
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<NodeLabelUpdate, Exception> labelUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final AllEntriesLabelScanReader nodeLabelRanges = (AllEntriesLabelScanReader)Mockito.mock(AllEntriesLabelScanReader.class);

    DynamicIndexStoreViewTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.labelScanStore.allNodeLabelRanges()).thenReturn((Object)this.nodeLabelRanges);
    }

    @Test
    void visitOnlyLabeledNodes() throws Exception {
        LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)labelScanReader);
        Mockito.when((Object)this.nodeLabelRanges.maxCount()).thenReturn((Object)1L);
        long[] nodeIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        PrimitiveLongResourceIterator labeledNodesIterator = PrimitiveLongResourceCollections.iterator(null, (long[])nodeIds);
        Mockito.when((Object)labelScanReader.nodesWithAnyOfLabels(new int[]{2, 6})).thenReturn((Object)labeledNodesIterator);
        for (long nodeId : nodeIds) {
            ((StubStorageCursors.NodeData)this.cursors.withNode(nodeId).propertyId(1L)).relationship(1L).labels(2L, 6L);
        }
        long id = nodeIds[nodeIds.length - 1] + 1L;
        for (long i = 0L; i < 10L; ++i) {
            this.cursors.withNode(id);
        }
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView();
        StoreScan storeScan = storeView.visitNodes(new int[]{2, 6}, this.propertyKeyIdFilter, this.propertyUpdateVisitor, this.labelUpdateVisitor, false);
        storeScan.run();
        ((Visitor)Mockito.verify(this.labelUpdateVisitor, (VerificationMode)Mockito.times((int)nodeIds.length))).visit((Object)((NodeLabelUpdate)ArgumentMatchers.any()));
    }

    private DynamicIndexStoreView dynamicIndexStoreView() {
        LockService locks = LockService.NO_LOCK_SERVICE;
        Supplier<StorageReader> storageReaderSupplier = () -> this.cursors;
        return new DynamicIndexStoreView(new NeoStoreIndexStoreView(locks, storageReaderSupplier), this.labelScanStore, locks, storageReaderSupplier, (LogProvider)NullLogProvider.getInstance());
    }
}

