/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Worker;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseEventListeners;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.DatabasePanicEventGenerator;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class Runner
implements Callable<Long> {
    private final DatabaseLayout databaseLayout;
    private final BooleanSupplier condition;
    private final int threads;

    public Runner(DatabaseLayout databaseLayout, BooleanSupplier condition, int threads) {
        this.databaseLayout = databaseLayout;
        this.condition = condition;
        this.threads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long lastCommittedTransactionId;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             Lifespan life = new Lifespan(new Lifecycle[0]);){
            SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
            TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
            LogFiles logFiles = (LogFiles)life.add((Lifecycle)this.createLogFiles(transactionIdStore, (FileSystemAbstraction)fileSystem));
            TransactionAppender transactionAppender = (TransactionAppender)life.add((Lifecycle)Runner.createBatchingTransactionAppender(transactionIdStore, transactionMetadataCache, logFiles));
            ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
            try {
                Future[] handlers = new Future[this.threads];
                for (int i = 0; i < this.threads; ++i) {
                    TransactionRepresentationFactory factory = new TransactionRepresentationFactory();
                    Worker task = new Worker(transactionAppender, factory, this.condition);
                    handlers[i] = executorService.submit(task);
                }
                for (Future handle : handlers) {
                    handle.get();
                }
            }
            finally {
                executorService.shutdown();
            }
            lastCommittedTransactionId = transactionIdStore.getLastCommittedTransactionId();
        }
        return lastCommittedTransactionId;
    }

    private static BatchingTransactionAppender createBatchingTransactionAppender(TransactionIdStore transactionIdStore, TransactionMetadataCache transactionMetadataCache, LogFiles logFiles) {
        NullLog log = NullLog.getInstance();
        DatabaseEventListeners databaseEventListeners = new DatabaseEventListeners((Log)log);
        DatabasePanicEventGenerator panicEventGenerator = new DatabasePanicEventGenerator(databaseEventListeners, "neo4j");
        DatabaseHealth databaseHealth = new DatabaseHealth(panicEventGenerator, (Log)log);
        LogRotationImpl logRotation = new LogRotationImpl(logFiles, Clock.systemUTC(), (Health)databaseHealth, LogRotationMonitorAdapter.EMPTY);
        return new BatchingTransactionAppender(logFiles, (LogRotation)logRotation, transactionMetadataCache, transactionIdStore, (Health)databaseHealth);
    }

    private LogFiles createLogFiles(TransactionIdStore transactionIdStore, FileSystemAbstraction fileSystemAbstraction) throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fileSystemAbstraction).withTransactionIdStore(transactionIdStore).withLogVersionRepository((LogVersionRepository)logVersionRepository).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).withStoreId(StoreId.UNKNOWN).build();
    }
}

