/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;

class FileCountThresholdTest {
    private final File file = (File)Mockito.mock(File.class);
    private final long version = 1L;
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);

    FileCountThresholdTest() {
    }

    @Test
    void shouldReturnFalseWhenTheMaxNonEmptyLogCountIsNotReached() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2L);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void shouldReturnTrueWhenTheMaxNonEmptyLogCountIsReached() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void shouldResetTheCounterWhenInitIsCalled() {
        int maxNonEmptyLogCount = 2;
        FileCountThreshold threshold = new FileCountThreshold(2L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        threshold.reached(this.file, 1L, this.source);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertFalse((boolean)result);
    }
}

