/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

class EntryCountThresholdTest {
    private final LogFileInformation info = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final File file = (File)Mockito.mock(File.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    EntryCountThresholdTest() {
    }

    @Test
    void shouldReportThresholdReachedWhenThresholdIsReached() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstEntryId(version + 1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)2L);
        EntryCountThreshold threshold = this.createThreshold(1);
        boolean reached = threshold.reached(this.file, version, this.info);
        Assertions.assertTrue((boolean)reached);
    }

    @Test
    void shouldReportThresholdNotReachedWhenThresholdIsNotReached() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstEntryId(version)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(version + 1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)1L);
        EntryCountThreshold threshold = this.createThreshold(1);
        Assertions.assertFalse((boolean)threshold.reached(this.file, version, this.info));
    }

    @Test
    void shouldProperlyHandleCaseWithOneEntryPerLogFile() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)2L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)3L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)3L);
        EntryCountThreshold threshold = this.createThreshold(1);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
    }

    @Test
    void shouldWorkWhenCalledMultipleTimesKeeping2Files() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstEntryId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)18L);
        EntryCountThreshold threshold = this.createThreshold(8);
        Assertions.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    void shouldWorkWhenCalledMultipleTimesKeeping3Files() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstEntryId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)18L);
        EntryCountThreshold threshold = this.createThreshold(15);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 1L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    void shouldWorkWhenCalledMultipleTimesKeeping1FileOnBoundary() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstEntryId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)18L);
        EntryCountThreshold threshold = this.createThreshold(3);
        Assertions.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    void shouldSkipEmptyLogsBetweenLogsThatWillBeKept() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(4L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(5L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(6L)).thenReturn((Object)13L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)13L);
        EntryCountThreshold threshold = this.createThreshold(9);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 5L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 4L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
        Assertions.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
    }

    @Test
    void shouldDeleteNonEmptyLogThatIsAfterASeriesOfEmptyLogs() throws Exception {
        Mockito.when((Object)this.info.getFirstEntryId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstEntryId(3L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(4L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(5L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstEntryId(6L)).thenReturn((Object)13L);
        Mockito.when((Object)this.info.getLastEntryId()).thenReturn((Object)13L);
        EntryCountThreshold threshold = this.createThreshold(8);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 5L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 4L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 3L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 2L, this.info));
        Assertions.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
    }

    @Test
    void thresholdNotReachedWhenNextEntryIdNotFound() throws IOException {
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenReturn((Object)-1L);
        EntryCountThreshold threshold = this.createThreshold(0);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 1L, this.info));
        this.logProvider.rawMessageMatcher().assertContains("Fail to get id of the first entry in the next transaction log file. Requested version: 2");
    }

    @Test
    void thresholdNotReachedWhenFailToGetNextEntryId() throws IOException {
        Mockito.when((Object)this.info.getFirstEntryId(2L)).thenThrow(new Throwable[]{new IOException("Exception.")});
        EntryCountThreshold threshold = this.createThreshold(0);
        Assertions.assertFalse((boolean)threshold.reached(this.file, 1L, this.info));
        this.logProvider.rawMessageMatcher().assertContains("Error on attempt to get entry ids from transaction log files. Checked version: 1");
    }

    private EntryCountThreshold createThreshold(int maxTxCount) {
        return new EntryCountThreshold((LogProvider)this.logProvider, (long)maxTxCount);
    }
}

