/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.OtherThreadRule;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogFileRotateAndReadRaceIT {
    @Inject
    private LifeSupport life;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private final OtherThreadRule<Void> t2 = new OtherThreadRule();
    private static final long LIMIT_TIME = TimeUnit.SECONDS.toMillis(5L);
    private static final int LIMIT_ROTATIONS = 500;
    private static final int LIMIT_READS = 1000;

    TransactionLogFileRotateAndReadRaceIT() {
    }

    @BeforeEach
    void setUp() {
        this.t2.init(this.getClass().getName() + "-T2");
    }

    @AfterEach
    void tearDown() {
        this.t2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotSeeEmptyLogFileWhenReadingTransactionStream() throws Exception {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
        LogPositionMarker startPosition = new LogPositionMarker();
        writer.getCurrentPosition(startPosition);
        AtomicBoolean end = new AtomicBoolean();
        byte[] dataChunk = new byte[100];
        AtomicInteger rotations = new AtomicInteger();
        CountDownLatch startSignal = new CountDownLatch(1);
        long maxEndTime = System.currentTimeMillis() + LIMIT_TIME;
        Future writeFuture = this.t2.execute(ignored -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            startSignal.countDown();
            while (!end.get() && System.currentTimeMillis() < maxEndTime) {
                writer.put(dataChunk, random.nextInt(1, dataChunk.length));
                if (!logFile.rotationNeeded()) continue;
                logFile.rotate();
                writer.getCurrentPosition(startPosition);
                rotations.incrementAndGet();
            }
            return null;
        });
        Assertions.assertTrue((boolean)startSignal.await(10L, TimeUnit.SECONDS));
        try {
            for (int reads = 0; System.currentTimeMillis() < maxEndTime && reads < 1000 && rotations.get() < 500; ++reads) {
                try (ReadableLogChannel reader = logFile.getReader(startPosition.newPosition());){
                    TransactionLogFileRotateAndReadRaceIT.deplete(reader);
                    continue;
                }
            }
        }
        finally {
            end.set(true);
            writeFuture.get();
        }
    }

    private static void deplete(ReadableLogChannel reader) {
        byte[] dataChunk = new byte[100];
        try {
            while (true) {
                reader.get(dataChunk, dataChunk.length);
            }
        }
        catch (ReadPastEndException readPastEndException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

