/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

class KernelTokenTest {
    private KernelTransactionImplementation ktx;
    private TransactionState transactionState;
    private CommandCreationContext commandCreationContext;
    private KernelToken kernelToken;
    private StorageReader storageReader;
    private TokenHolders tokenHolders;
    private TokenHolder propertyKeyTokens;
    private TokenHolder labelTokens;
    private TokenHolder relationshipTypeTokens;

    KernelTokenTest() {
    }

    @BeforeEach
    void setUp() {
        this.ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        this.transactionState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)this.ktx.txState()).thenReturn((Object)this.transactionState);
        this.commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        this.storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        this.propertyKeyTokens = (TokenHolder)Mockito.mock(TokenHolder.class);
        this.labelTokens = (TokenHolder)Mockito.mock(TokenHolder.class);
        this.relationshipTypeTokens = (TokenHolder)Mockito.mock(TokenHolder.class);
        this.tokenHolders = new TokenHolders(this.propertyKeyTokens, this.labelTokens, this.relationshipTypeTokens);
        this.kernelToken = new KernelToken(this.storageReader, this.commandCreationContext, this.ktx, this.tokenHolders);
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingLabelTokenId() throws KernelException {
        this.kernelToken.labelCreateForName("MyLabel", false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ktx, this.commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)this.ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)this.commandCreationContext)).reserveLabelTokenId();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingPropertyKeyTokenId() throws KernelException {
        this.kernelToken.propertyKeyCreateForName("MyKey", false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ktx, this.commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)this.ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)this.commandCreationContext)).reservePropertyKeyTokenId();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingRelationshipTypeTokenId() throws KernelException {
        this.kernelToken.relationshipTypeCreateForName("MyType", false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ktx, this.commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)this.ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)this.commandCreationContext)).reserveRelationshipTypeTokenId();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void invalidTokenNamesAreNotAllowed() {
        List<String> invalidNames = List.of("", "\u0000", "`", "``", "`a`", "a`b", "a``b");
        Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.labelGetOrCreateForName(null), (String)"label name should be invalid: null");
        Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.relationshipTypeGetOrCreateForName(null), (String)"relationship type name should be invalid: null");
        Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.propertyKeyGetOrCreateForName(null), (String)"property key name should be invalid: null");
        for (String invalidName : invalidNames) {
            Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.labelGetOrCreateForName(invalidName), (String)("label name should be invalid: '" + invalidName + "'"));
            Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.relationshipTypeGetOrCreateForName(invalidName), (String)("relationship type name should be invalid: '" + invalidName + "'"));
            Assertions.assertThrows(IllegalTokenNameException.class, () -> this.kernelToken.propertyKeyGetOrCreateForName(invalidName), (String)("property key name name should be invalid: '" + invalidName + "'"));
        }
    }

    @Test
    void allowedSpecialCharactersInTokenNames() throws KernelException {
        List<String> validFancyTokenNames = List.of("\t", " ", "  ", "\n", "\r", "\ud83d\ude02", "\"", "'", "%", "@", "#", "$", "{", "}");
        for (String validName : validFancyTokenNames) {
            this.kernelToken.labelGetOrCreateForName(validName);
            this.kernelToken.relationshipTypeGetOrCreateForName(validName);
            this.kernelToken.propertyKeyGetOrCreateForName(validName);
        }
    }
}

