/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.test.extension.actors.Actor;

abstract class StopCompatibility
extends LockCompatibilityTestSupport {
    private static final long FIRST_NODE_ID = 42L;
    private static final long SECOND_NODE_ID = 4242L;
    private static final LockTracer TRACER = LockTracer.NONE;
    private Locks.Client client;

    StopCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @BeforeEach
    void setUp() {
        this.client = this.locks.newClient();
    }

    @AfterEach
    void tearDown() {
        this.client.close();
    }

    @Test
    void mustReleaseWriteLockWaitersOnStop() {
        this.clientA.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientC.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        this.acquireExclusive(this.clientB, TRACER, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.acquireExclusive(this.clientC, TRACER, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientC.stop();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)0, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void mustNotReleaseLocksAfterPrepareOnStop() {
        this.clientA.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.prepare();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)2, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void mustReleaseUnpreparedLocksOnStop() {
        this.clientA.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)0, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void mustReleaseReadLockWaitersOnStop() {
        this.clientA.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.acquireShared(this.clientB, TRACER, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)0, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void prepareMustAllowAcquiringNewLocksAfterStop() {
        this.clientA.prepare();
        this.clientA.stop();
        this.clientA.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assertions.assertEquals((int)2, (int)lockCountVisitor.getLockCount());
    }

    @Test
    void prepareMustThrowWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().prepare());
    }

    @Test
    void acquireSharedThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void acquireExclusiveThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void trySharedLockThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().trySharedLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void tryExclusiveLockThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L));
    }

    @Test
    void releaseSharedThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void releaseExclusiveThrowsWhenClientStopped() {
        Assertions.assertThrows(LockClientStoppedException.class, () -> this.stoppedClient().releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L}));
    }

    @Test
    void sharedLockCanBeStopped() throws Exception {
        this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition);
        sharedLockAcquisition.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition);
    }

    @Test
    void exclusiveLockCanBeStopped() throws Exception {
        this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition);
        exclusiveLockAcquisition.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition);
    }

    @Test
    void acquireSharedLockAfterSharedLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition1 = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition1);
        sharedLockAcquisition1.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition1);
        thisThreadsExclusiveLock.release();
        LockAcquisition sharedLockAcquisition2 = this.acquireSharedLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(sharedLockAcquisition2);
    }

    @Test
    void acquireExclusiveLockAfterExclusiveLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition1 = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition1);
        exclusiveLockAcquisition1.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition1);
        thisThreadsExclusiveLock.release();
        LockAcquisition exclusiveLockAcquisition2 = this.acquireExclusiveLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(exclusiveLockAcquisition2);
    }

    @Test
    void acquireSharedLockAfterExclusiveLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition);
        exclusiveLockAcquisition.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition);
        thisThreadsExclusiveLock.release();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(sharedLockAcquisition);
    }

    @Test
    void acquireExclusiveLockAfterSharedLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition);
        sharedLockAcquisition.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition);
        thisThreadsExclusiveLock.release();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(exclusiveLockAcquisition);
    }

    @Test
    void acquireSharedLockAfterSharedLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(true, true);
    }

    @Test
    void acquireExclusiveLockAfterExclusiveLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(false, false);
    }

    @Test
    void acquireSharedLockAfterExclusiveLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(true, false);
    }

    @Test
    void acquireExclusiveLockAfterSharedLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(false, true);
    }

    @Test
    void closeClientAfterSharedLockStopped() throws Exception {
        this.closeClientAfterLockStopped(true);
    }

    @Test
    void closeClientAfterExclusiveLockStopped() throws Exception {
        this.closeClientAfterLockStopped(false);
    }

    @Test
    void acquireExclusiveLockWhileHoldingSharedLockCanBeStopped() throws Exception {
        AcquiredLock thisThreadsSharedLock = this.acquireSharedLockInThisThread();
        CountDownLatch sharedLockAcquired = new CountDownLatch(1);
        CountDownLatch startExclusiveLock = new CountDownLatch(1);
        LockAcquisition acquisition = this.acquireSharedAndExclusiveLocksInAnotherThread(sharedLockAcquired, startExclusiveLock);
        StopCompatibility.await(sharedLockAcquired);
        startExclusiveLock.countDown();
        this.assertThreadIsWaitingForLock(acquisition);
        acquisition.stop();
        this.assertLockAcquisitionFailed(acquisition);
        thisThreadsSharedLock.release();
        this.assertNoLocksHeld();
    }

    private Locks.Client stoppedClient() {
        try {
            this.client.stop();
            return this.client;
        }
        catch (Throwable t) {
            throw new AssertionError("Unable to stop client", t);
        }
    }

    private void closeClientAfterLockStopped(boolean shared) throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        CountDownLatch firstLockAcquired = new CountDownLatch(1);
        LockAcquisition acquisition = this.tryAcquireTwoLocksLockInAnotherThread(shared, firstLockAcquired);
        StopCompatibility.await(firstLockAcquired);
        this.assertThreadIsWaitingForLock(acquisition);
        this.assertLocksHeld(42L, 4242L);
        acquisition.stop();
        this.assertLockAcquisitionFailed(acquisition);
        this.assertLocksHeld(42L);
        thisThreadsExclusiveLock.release();
        this.assertNoLocksHeld();
    }

    private void acquireLockAfterOtherLockStoppedSameThread(boolean firstLockShared, boolean secondLockShared) throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        CountDownLatch firstLockFailed = new CountDownLatch(1);
        CountDownLatch startSecondLock = new CountDownLatch(1);
        LockAcquisition lockAcquisition = this.acquireTwoLocksInAnotherThread(firstLockShared, secondLockShared, firstLockFailed, startSecondLock);
        this.assertThreadIsWaitingForLock(lockAcquisition);
        lockAcquisition.stop();
        StopCompatibility.await(firstLockFailed);
        thisThreadsExclusiveLock.release();
        startSecondLock.countDown();
        this.assertLockAcquisitionSucceeded(lockAcquisition);
    }

    private AcquiredLock acquireSharedLockInThisThread() {
        this.client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        this.assertLocksHeld(42L);
        return AcquiredLock.shared(this.client, (ResourceType)ResourceTypes.NODE, 42L);
    }

    private AcquiredLock acquireExclusiveLockInThisThread() {
        this.client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        this.assertLocksHeld(42L);
        return AcquiredLock.exclusive(this.client, (ResourceType)ResourceTypes.NODE, 42L);
    }

    private LockAcquisition acquireSharedLockInAnotherThread() {
        return this.acquireLockInAnotherThread(true);
    }

    private LockAcquisition acquireExclusiveLockInAnotherThread() {
        return this.acquireLockInAnotherThread(false);
    }

    private LockAcquisition acquireLockInAnotherThread(boolean shared) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future future = this.threadA.submit(() -> {
            Locks.Client client = this.newLockClient(lockAcquisition);
            if (shared) {
                client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
            } else {
                client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA);
        return lockAcquisition;
    }

    private LockAcquisition acquireTwoLocksInAnotherThread(boolean firstShared, boolean secondShared, CountDownLatch firstLockFailed, CountDownLatch startSecondLock) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future future = this.threadA.submit(() -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                try {
                    if (firstShared) {
                        client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                    } else {
                        client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                    }
                    Assertions.fail((String)"Transaction termination expected");
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(LockClientStoppedException.class));
                }
            }
            lockAcquisition.setClient(null);
            firstLockFailed.countDown();
            StopCompatibility.await(startSecondLock);
            client = this.newLockClient(lockAcquisition);
            try {
                if (secondShared) {
                    client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                } else {
                    client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA);
        return lockAcquisition;
    }

    private LockAcquisition acquireSharedAndExclusiveLocksInAnotherThread(CountDownLatch sharedLockAcquired, CountDownLatch startExclusiveLock) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future future = this.threadA.submit(() -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                sharedLockAcquired.countDown();
                StopCompatibility.await(startExclusiveLock);
                client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA);
        return lockAcquisition;
    }

    private LockAcquisition tryAcquireTwoLocksLockInAnotherThread(boolean shared, CountDownLatch firstLockAcquired) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future future = this.threadA.submit(() -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                if (shared) {
                    client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{4242L});
                } else {
                    client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{4242L});
                }
                firstLockAcquired.countDown();
                if (shared) {
                    client.acquireShared(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                } else {
                    client.acquireExclusive(TRACER, (ResourceType)ResourceTypes.NODE, new long[]{42L});
                }
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA);
        return lockAcquisition;
    }

    private Locks.Client newLockClient(LockAcquisition lockAcquisition) {
        Locks.Client client = this.locks.newClient();
        lockAcquisition.setClient(client);
        return client;
    }

    private void assertLocksHeld(Long ... expectedResourceIds) {
        List<Long> expectedLockedIds = Arrays.asList(expectedResourceIds);
        ArrayList seenLockedIds = new ArrayList();
        this.locks.accept((resourceType, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> seenLockedIds.add(resourceId));
        Collections.sort(expectedLockedIds);
        Collections.sort(seenLockedIds);
        Assertions.assertEquals(expectedLockedIds, seenLockedIds, (String)"unexpected locked resource ids");
    }

    private void assertNoLocksHeld() {
        this.locks.accept((resourceType, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> Assertions.fail((String)("Unexpected lock on " + resourceType + " " + resourceId)));
    }

    private void assertThreadIsWaitingForLock(LockAcquisition lockAcquisition) throws Exception {
        for (int i = 0; i < 30 && !this.suite.isAwaitingLockAcquisition(lockAcquisition.executor); ++i) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        Assertions.assertFalse((boolean)lockAcquisition.completed(), (String)"locking thread completed");
    }

    private void assertLockAcquisitionSucceeded(LockAcquisition lockAcquisition) throws Exception {
        boolean completed = false;
        for (int i = 0; i < 30; ++i) {
            try {
                Assertions.assertNull((Object)lockAcquisition.result());
                completed = true;
                continue;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((boolean)completed, (String)"lock was not acquired in time");
        Assertions.assertTrue((boolean)lockAcquisition.completed(), (String)"locking thread seem to be still in progress");
    }

    private void assertLockAcquisitionFailed(LockAcquisition lockAcquisition) {
        Throwable executionException = null;
        for (int i = 0; i < 30; ++i) {
            Exception e = (Exception)Assertions.assertThrows(Exception.class, lockAcquisition::result);
            if (!(e instanceof ExecutionException)) continue;
            executionException = (ExecutionException)e;
            break;
        }
        Assertions.assertNotNull(executionException, (String)"execution should fail");
        MatcherAssert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(LockClientStoppedException.class));
        Assertions.assertTrue((boolean)lockAcquisition.completed(), (String)"locking thread seem to be still in progress");
    }

    private static void await(CountDownLatch latch) throws InterruptedException {
        if (!latch.await(1L, TimeUnit.MINUTES)) {
            Assertions.fail((String)"Count down did not happen");
        }
    }

    private static class AcquiredLock {
        final Locks.Client client;
        final boolean shared;
        final ResourceType resourceType;
        final long resourceId;

        AcquiredLock(Locks.Client client, boolean shared, ResourceType resourceType, long resourceId) {
            this.client = client;
            this.shared = shared;
            this.resourceType = resourceType;
            this.resourceId = resourceId;
        }

        static AcquiredLock shared(Locks.Client client, ResourceType resourceType, long resourceId) {
            return new AcquiredLock(client, true, resourceType, resourceId);
        }

        static AcquiredLock exclusive(Locks.Client client, ResourceType resourceType, long resourceId) {
            return new AcquiredLock(client, false, resourceType, resourceId);
        }

        void release() {
            if (this.shared) {
                this.client.releaseShared(this.resourceType, new long[]{this.resourceId});
            } else {
                this.client.releaseExclusive(this.resourceType, new long[]{this.resourceId});
            }
        }
    }

    private static class LockAcquisition {
        volatile Future<?> future;
        volatile Locks.Client client;
        volatile Actor executor;

        private LockAcquisition() {
        }

        Future<?> getFuture() {
            Objects.requireNonNull(this.future, "lock acquisition was not initialized with future");
            return this.future;
        }

        void setFuture(Future<?> future, Actor executor) {
            this.future = future;
            this.executor = executor;
        }

        Locks.Client getClient() {
            Objects.requireNonNull(this.client, "lock acquisition was not initialized with client");
            return this.client;
        }

        void setClient(Locks.Client client) {
            this.client = client;
        }

        Object result() throws InterruptedException, ExecutionException, TimeoutException {
            return this.getFuture().get(100L, TimeUnit.MILLISECONDS);
        }

        boolean completed() {
            return this.getFuture().isDone();
        }

        void stop() {
            this.getClient().stop();
        }
    }
}

