/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

abstract class DeadlockCompatibility
extends LockCompatibilityTestSupport {
    DeadlockCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void shouldDetectTwoClientExclusiveDeadlock() throws Exception {
        this.acquireExclusive(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).call().get();
        this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L).call().get();
        this.assertDetectsDeadlock(this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L));
    }

    @Test
    void shouldDetectThreeClientExclusiveDeadlock() throws Exception {
        this.acquireExclusive(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).call().get();
        this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L).call().get();
        this.acquireExclusive(this.clientC, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 3L).call().get();
        this.assertDetectsDeadlock(this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientC, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L), this.acquireExclusive(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    void shouldDetectMixedExclusiveAndSharedDeadlock() throws Exception {
        this.acquireShared(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L).call().get();
        this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L).call().get();
        this.assertDetectsDeadlock(this.acquireExclusive(this.clientB, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 1L), this.acquireShared(this.clientA, LockTracer.NONE, (ResourceType)ResourceTypes.NODE, 2L));
    }

    private void assertDetectsDeadlock(LockCompatibilityTestSupport.LockCommand ... commands) {
        List calls = Arrays.stream(commands).map(LockCompatibilityTestSupport.LockCommand::call).collect(Collectors.toList());
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout) {
            for (Future call : calls) {
                if (!this.tryDetectDeadlock(call)) continue;
                return;
            }
        }
        throw new AssertionError((Object)"Failed to detect deadlock. Expected lock manager to detect deadlock, but none of the clients reported any deadlocks.");
    }

    private boolean tryDetectDeadlock(Future<Void> call) {
        try {
            call.get(1L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DeadlockDetectedException) {
                return true;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
        return false;
    }
}

