/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Iterator;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ResultCursor
implements Seeker<GenericKey, NativeIndexValue> {
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private final Iterator<String> iterator;
    private int pos = -1;
    private GenericKey key;

    ResultCursor(Iterator<String> keys) {
        this.iterator = keys;
    }

    public boolean next() {
        if (this.iterator.hasNext()) {
            String current = this.iterator.next();
            ++this.pos;
            this.key = new GenericKey(specificSettings);
            this.key.initialize((long)this.pos);
            this.key.initFromValue(0, (Value)Values.stringValue((String)current), NativeIndexKey.Inclusion.NEUTRAL);
            return true;
        }
        return false;
    }

    public void close() {
    }

    public GenericKey key() {
        return this.key;
    }

    public NativeIndexValue value() {
        return NativeIndexValue.INSTANCE;
    }
}

