/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

class NativeIndexPopulatorTestCases {
    static final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final StandardConfiguration configuration = new StandardConfiguration();

    NativeIndexPopulatorTestCases() {
    }

    static PopulatorFactory<GenericKey, NativeIndexValue> genericPopulatorFactory() {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> new GenericNativeIndexPopulator(pageCache, fs, storeFile, layout, monitor, descriptor, spaceFillingCurveSettings, (SpaceFillingCurveConfiguration)configuration, false);
    }

    static PopulatorFactory<GenericKey, NativeIndexValue> genericBlockBasedPopulatorFactory() {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> new GenericBlockBasedIndexPopulator(pageCache, fs, storeFile, layout, monitor, descriptor, spaceFillingCurveSettings, (SpaceFillingCurveConfiguration)configuration, false, ByteBufferFactory.heapBufferFactory((int)10240));
    }

    @FunctionalInterface
    public static interface PopulatorFactory<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        public NativeIndexPopulator<KEY, VALUE> create(PageCache var1, FileSystemAbstraction var2, IndexFiles var3, IndexLayout<KEY, VALUE> var4, IndexProvider.Monitor var5, IndexDescriptor var6) throws IOException;
    }
}

