/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;

class NativeIndexHeaderReaderTest {
    NativeIndexHeaderReaderTest() {
    }

    @Test
    void mustReportFailedIfNoHeader() {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        NativeIndexHeaderReader nativeIndexHeaderReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        nativeIndexHeaderReader.read(emptyBuffer);
        Assertions.assertSame((Object)0, (Object)nativeIndexHeaderReader.state);
        MatcherAssert.assertThat((Object)nativeIndexHeaderReader.failureMessage, (Matcher)Matchers.containsString((String)"Could not read header, most likely caused by index not being fully constructed. Index needs to be recreated. Stacktrace:"));
    }

    @Test
    void mustReportFailedIfHeaderTooShort() {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[1]);
        NativeIndexHeaderReader nativeIndexHeaderReader = new NativeIndexHeaderReader(ByteBuffer::get);
        nativeIndexHeaderReader.read(emptyBuffer);
        Assertions.assertSame((Object)0, (Object)nativeIndexHeaderReader.state);
        MatcherAssert.assertThat((Object)nativeIndexHeaderReader.failureMessage, (Matcher)Matchers.containsString((String)"Could not read header, most likely caused by index not being fully constructed. Index needs to be recreated. Stacktrace:"));
    }

    @Test
    void mustNotThrowIfHeaderLongEnough() {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[1]);
        NativeIndexHeaderReader nativeIndexHeaderReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        nativeIndexHeaderReader.read(emptyBuffer);
    }
}

