/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class GenericKeyStateCompareTest {
    GenericKeyStateCompareTest() {
    }

    @Test
    void compareGenericKeyState() {
        List<Value> allValues = Arrays.asList(Values.of((Object)"string1"), Values.of((Object)42), Values.of((Object)true), Values.of((Object)new char[]{'a', 'z'}), Values.of((Object)new String[]{"arrayString1", "arraysString2"}), Values.of((Object)new byte[]{1, 12}), Values.of((Object)new short[]{314, 1337}), Values.of((Object)new int[]{3140, 13370}), Values.of((Object)new long[]{31400L, 133700L}), Values.of((Object)new boolean[]{false, true}), DateValue.epochDate((long)2L), LocalTimeValue.localTime((long)100000L), TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)43201000000000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.of("+01:00")), TimeValue.time((long)46800000000000L, (ZoneOffset)ZoneOffset.UTC), LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)13, (int)50, (int)42, (int)1337), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"UTC"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"Europe/Stockholm"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2015, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)4, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)26, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)13, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)46, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)14, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7475, (String)"+05:00"), DateTimeValue.datetime((int)2038, (int)1, (int)18, (int)9, (int)14, (int)7, (int)0, (String)"-18:00"), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneOffset)ZoneOffset.ofTotalSeconds(3)), DateTimeValue.datetime((long)10000L, (long)101L, (ZoneOffset)ZoneOffset.ofTotalSeconds(-3)), DurationValue.duration((long)10L, (long)20L, (long)30L, (long)40L), DurationValue.duration((long)11L, (long)20L, (long)30L, (long)40L), DurationValue.duration((long)10L, (long)21L, (long)30L, (long)40L), DurationValue.duration((long)10L, (long)20L, (long)31L, (long)40L), DurationValue.duration((long)10L, (long)20L, (long)30L, (long)41L), Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(2018, 10, 9, 8, 7, 6, 5, ZoneId.of("UTC")), ZonedDateTime.of(2017, 9, 8, 7, 6, 5, 4, ZoneId.of("UTC"))}), Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5), LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5)}), Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(20, 8, 7, 6, ZoneOffset.UTC), OffsetTime.of(20, 8, 7, 6, ZoneOffset.UTC)}), Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(2018, 12, 28), LocalDate.of(2018, 12, 28)}), Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(9, 28), LocalTime.of(9, 28)}), Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((long)12L, (long)10L, (long)10L, (long)10L), DurationValue.duration((long)12L, (long)10L, (long)10L, (long)10L)}));
        allValues.sort((Comparator<Value>)Values.COMPARATOR);
        ArrayList<GenericKey> states = new ArrayList<GenericKey>();
        for (Value value : allValues) {
            GenericKey state = new GenericKey(null);
            state.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
            states.add(state);
        }
        Collections.shuffle(states);
        states.sort(GenericKey::compareValueTo);
        List sortedStatesAsValues = states.stream().map(GenericKey::asValue).collect(Collectors.toList());
        Assertions.assertEquals(allValues, sortedStatesAsValues);
    }
}

