/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.PathProxy;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

class PathProxyTest {
    private final InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);

    PathProxyTest() {
    }

    @Test
    void shouldIterateThroughNodes() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.nodes().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)1L, (long)node.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)2L, (long)node.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)3L, (long)node.getId());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughNodesInReverse() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseNodes().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Node node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)3L, (long)node.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)2L, (long)node.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        node = (Node)iterator.next();
        MatcherAssert.assertThat((Object)node, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)1L, (long)node.getId());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughRelationships() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.relationships().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        MatcherAssert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)100L, (long)relationship.getId());
        Assertions.assertEquals((long)1L, (long)relationship.getStartNodeId());
        Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        MatcherAssert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)200L, (long)relationship.getId());
        Assertions.assertEquals((long)3L, (long)relationship.getStartNodeId());
        Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateThroughRelationshipsInReverse() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.reverseRelationships().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Relationship relationship = (Relationship)iterator.next();
        MatcherAssert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)200L, (long)relationship.getId());
        Assertions.assertEquals((long)3L, (long)relationship.getStartNodeId());
        Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        relationship = (Relationship)iterator.next();
        MatcherAssert.assertThat((Object)relationship, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)100L, (long)relationship.getId());
        Assertions.assertEquals((long)1L, (long)relationship.getStartNodeId());
        Assertions.assertEquals((long)2L, (long)relationship.getEndNodeId());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldIterateAlternatingNodesAndRelationships() {
        PathProxy path = new PathProxy(this.transaction, new long[]{1L, 2L, 3L}, new long[]{100L, 200L}, new int[]{0, -1});
        Iterator iterator = path.iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Entity entity = (Entity)iterator.next();
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)1L, (long)entity.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)100L, (long)entity.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)2L, (long)entity.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Relationship.class));
        Assertions.assertEquals((long)200L, (long)entity.getId());
        Assertions.assertTrue((boolean)iterator.hasNext());
        entity = (Entity)iterator.next();
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.instanceOf(Node.class));
        Assertions.assertEquals((long)3L, (long)entity.getId());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

