/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class TxStateVisitorTest {
    private TransactionState state;
    private final Collection<StorageProperty> noProperty = Collections.emptySet();

    TxStateVisitorTest() {
    }

    @Test
    void shouldSeeAddedRelationshipProperties() throws Exception {
        long relId = 1L;
        int propKey = 2;
        GatheringVisitor visitor = new GatheringVisitor();
        Value value = Values.of((Object)"hello");
        this.state.relationshipDoReplaceProperty(relId, propKey, Values.of((Object)""), value);
        this.state.accept((TxStateVisitor)visitor);
        PropertyKeyValue prop = new PropertyKeyValue(propKey, Values.of((Object)"hello"));
        MatcherAssert.assertThat(visitor.relPropertyChanges, this.contains(this.propChange(relId, this.noProperty, Arrays.asList(prop), (IntIterable)IntSets.immutable.empty())));
    }

    private Matcher<List<GatheringVisitor.PropertyChange>> contains(GatheringVisitor.PropertyChange ... change) {
        return CoreMatchers.equalTo(Arrays.asList(change));
    }

    private GatheringVisitor.PropertyChange propChange(long relId, Collection<StorageProperty> added, List<StorageProperty> changed, IntIterable removed) {
        return new GatheringVisitor.PropertyChange(relId, added, changed, removed);
    }

    @BeforeEach
    void before() {
        this.state = new TxState();
    }

    static class GatheringVisitor
    extends TxStateVisitor.Adapter {
        List<PropertyChange> nodePropertyChanges = new ArrayList<PropertyChange>();
        List<PropertyChange> relPropertyChanges = new ArrayList<PropertyChange>();

        GatheringVisitor() {
        }

        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
            this.nodePropertyChanges.add(new PropertyChange(id, added, changed, removed));
        }

        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
            this.relPropertyChanges.add(new PropertyChange(id, added, changed, removed));
        }

        static class PropertyChange {
            final long entityId;
            final List<StorageProperty> added;
            final List<StorageProperty> changed;
            final IntList removed;

            PropertyChange(long entityId, Collection<StorageProperty> added, Collection<StorageProperty> changed, IntIterable removed) {
                this.entityId = entityId;
                this.added = Iterables.asList(added);
                this.changed = Iterables.asList(changed);
                this.removed = removed.toList();
            }

            PropertyChange(long entityId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
                this.entityId = entityId;
                this.added = Iterators.asList(added);
                this.changed = Iterators.asList(changed);
                this.removed = removed.toList();
            }

            public String toString() {
                return "PropertyChange{entityId=" + this.entityId + ", added=" + this.added + ", changed=" + this.changed + ", removed=" + this.removed + "}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PropertyChange that = (PropertyChange)o;
                if (this.entityId != that.entityId) {
                    return false;
                }
                if (!this.added.equals(that.added)) {
                    return false;
                }
                if (!this.changed.equals(that.changed)) {
                    return false;
                }
                return this.removed.equals((Object)that.removed);
            }

            public int hashCode() {
                int result = (int)(this.entityId ^ this.entityId >>> 32);
                result = 31 * result + this.added.hashCode();
                result = 31 * result + this.changed.hashCode();
                result = 31 * result + this.removed.hashCode();
                return result;
            }
        }
    }
}

