/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexDropper;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class FailedIndexProxyTest {
    private final IndexDropper indexDropper = (IndexDropper)Mockito.mock(IndexDropper.class);
    private final IndexPopulationFailure indexPopulationFailure = (IndexPopulationFailure)Mockito.mock(IndexPopulationFailure.class);
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);

    FailedIndexProxyTest() {
    }

    @Test
    void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() {
        String userDescription = "description";
        FailedIndexProxy index = new FailedIndexProxy(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName(userDescription).materialise(1L), userDescription, this.indexDropper, this.indexPopulationFailure, this.indexStatisticsStore, (LogProvider)NullLogProvider.getInstance());
        index.drop();
        ((IndexDropper)Mockito.verify((Object)this.indexDropper)).drop();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).removeIndex(ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexDropper, this.indexStatisticsStore});
    }

    @Test
    void shouldLogReasonForDroppingIndex() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        new FailedIndexProxy(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName("foo").materialise(1L), "foo", (IndexDropper)Mockito.mock(IndexPopulator.class), IndexPopulationFailure.failure((String)"it broke"), this.indexStatisticsStore, (LogProvider)logProvider).drop();
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(FailedIndexProxy.class).info("FailedIndexProxy#drop index on foo dropped due to:\nit broke")});
    }
}

