/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;

class KernelTransactionSecurityContextTest
extends KernelTransactionTestBase {
    KernelTransactionSecurityContextTest() {
    }

    @Test
    void shouldAllowReadsInAccessMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.access());
        Read reads = tx.dataRead();
        Assertions.assertNotNull((Object)reads);
    }

    @Test
    void shouldAllowTokenReadsInAccessMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.access());
        TokenRead tokenRead = tx.tokenRead();
        Assertions.assertNotNull((Object)tokenRead);
    }

    @Test
    void shouldNotAllowWritesInAccessMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.access());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).dataWrite());
    }

    @Test
    void shouldNotAllowSchemaWritesInAccessMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.access());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).schemaWrite());
    }

    @Test
    void shouldAllowReadsInReadMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        Read reads = tx.dataRead();
        Assertions.assertNotNull((Object)reads);
    }

    @Test
    void shouldNotAllowWriteAccessInReadMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).dataWrite());
    }

    @Test
    void shouldNotAllowSchemaWriteAccessInReadMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.read());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).schemaWrite());
    }

    @Test
    void shouldAllowReadAccessInWriteOnlyMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        Read reads = tx.dataRead();
        Assertions.assertNotNull((Object)reads);
    }

    @Test
    void shouldAllowTokenReadAccessInWriteOnlyMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        TokenRead tokenRead = tx.tokenRead();
        Assertions.assertNotNull((Object)tokenRead);
    }

    @Test
    void shouldAllowWriteAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        Write writes = tx.dataWrite();
        Assertions.assertNotNull((Object)writes);
    }

    @Test
    void shouldNotAllowSchemaWriteAccessInWriteOnlyMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.writeOnly());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).schemaWrite());
    }

    @Test
    void shouldAllowReadsInWriteMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        Read reads = tx.dataRead();
        Assertions.assertNotNull((Object)reads);
    }

    @Test
    void shouldAllowWritesInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        Write writes = tx.dataWrite();
        Assertions.assertNotNull((Object)writes);
    }

    @Test
    void shouldNotAllowSchemaWriteAccessInWriteMode() {
        KernelTransactionImplementation tx = this.newTransaction((LoginContext)AnonymousContext.write());
        Assertions.assertThrows(AuthorizationViolationException.class, () -> ((KernelTransactionImplementation)tx).schemaWrite());
    }

    @Test
    void shouldAllowReadsInFullMode() {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        Read reads = tx.dataRead();
        Assertions.assertNotNull((Object)reads);
    }

    @Test
    void shouldAllowWritesInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        Write writes = tx.dataWrite();
        Assertions.assertNotNull((Object)writes);
    }

    @Test
    void shouldAllowSchemaWriteAccessInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        SchemaWrite writes = tx.schemaWrite();
        Assertions.assertNotNull((Object)writes);
    }
}

