/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;

class MapCachingDatabaseIdRepositoryTest {
    private DatabaseIdRepository delegate = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
    private NamedDatabaseId otherNamedDbId = TestDatabaseIdRepository.randomNamedDatabaseId();
    private String otherDbName = this.otherNamedDbId.name();
    private DatabaseId otherDbid = this.otherNamedDbId.databaseId();
    private DatabaseIdRepository.Caching databaseIdRepository;

    MapCachingDatabaseIdRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.delegate.getByName(this.otherDbName)).thenReturn(Optional.of(this.otherNamedDbId));
        Mockito.when((Object)this.delegate.getById(this.otherDbid)).thenReturn(Optional.of(this.otherNamedDbId));
        this.databaseIdRepository = new MapCachingDatabaseIdRepository(this.delegate);
    }

    @Test
    void shouldDelegateGetByName() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getByName(this.otherDbName).get();
        MatcherAssert.assertThat((Object)namedDatabaseId, (Matcher)Matchers.equalTo((Object)this.otherNamedDbId));
    }

    @Test
    void shouldDelegateGetByUuid() {
        NamedDatabaseId databaseId = (NamedDatabaseId)this.databaseIdRepository.getById(this.otherDbid).get();
        MatcherAssert.assertThat((Object)databaseId, (Matcher)Matchers.equalTo((Object)this.otherNamedDbId));
    }

    @Test
    void shouldCacheDbByName() {
        this.databaseIdRepository.getByName(this.otherDbName).get();
        this.databaseIdRepository.getByName(this.otherDbName).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getByName(this.otherDbName);
    }

    @Test
    void shouldCacheDbByUuid() {
        this.databaseIdRepository.getById(this.otherDbid).get();
        this.databaseIdRepository.getById(this.otherDbid).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.atMostOnce())).getById(this.otherDbid);
    }

    @Test
    void shouldInvalidateBoth() {
        this.databaseIdRepository.getByName(this.otherDbName).get();
        this.databaseIdRepository.getById(this.otherDbid).get();
        this.databaseIdRepository.invalidate(this.otherNamedDbId);
        this.databaseIdRepository.getByName(this.otherDbName).get();
        this.databaseIdRepository.getById(this.otherDbid).get();
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).getByName(this.otherDbName);
        ((DatabaseIdRepository)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)2))).getById(this.otherDbid);
    }

    @Test
    void shouldCacheDbOnRequest() {
        this.databaseIdRepository.cache(this.otherNamedDbId);
        this.databaseIdRepository.getByName(this.otherDbName);
        this.databaseIdRepository.getById(this.otherDbid);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    void shouldReturnSystemDatabaseIdDirectlyByName() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getByName(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.name()).get();
        MatcherAssert.assertThat((Object)namedDatabaseId, (Matcher)Matchers.equalTo((Object)DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    void shouldReturnSystemDatabaseIdDirectlyByUuid() {
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository.getById(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.databaseId()).get();
        MatcherAssert.assertThat((Object)namedDatabaseId, (Matcher)Matchers.equalTo((Object)DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.delegate});
    }
}

