/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constraints;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;

class ConstraintDescriptorFactoryTest {
    private static final int LABEL_ID = 0;
    private static final int REL_TYPE_ID = 0;

    ConstraintDescriptorFactoryTest() {
    }

    @Test
    void shouldCreateExistsConstraintDescriptors() {
        NodeExistenceConstraintDescriptor desc = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateUniqueConstraintDescriptors() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateNodeKeyConstraintDescriptors() {
        NodeKeyConstraintDescriptor desc = ConstraintDescriptorFactory.nodeKeyForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.UNIQUE_EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateConstraintDescriptorsFromSchema() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.UNIQUE_EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintType.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1})));
    }

    @Test
    void shouldCreateEqualDescriptors() {
        UniquenessConstraintDescriptor desc1 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        UniquenessConstraintDescriptor desc2 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.existsForLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)"Constraint( EXISTS, :Label1(property2) )"));
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{3}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)"Constraint( EXISTS, -[:RelType1(property3)]- )"));
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)"Constraint( UNIQUE, :Label2(property4) )"));
    }
}

