/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.query.QueryObfuscation;

class QueryObfuscationTest {
    QueryObfuscationTest() {
    }

    @Test
    void shouldObfuscateCreateUserProcedure() {
        HashSet params = new HashSet();
        String obfuscated = QueryObfuscation.obfuscateText((String)"CALL dbms.security.createUser('foo', 'bar')", params);
        MatcherAssert.assertThat(params, (Matcher)Matchers.equalTo(Collections.emptySet()));
        MatcherAssert.assertThat((Object)obfuscated, (Matcher)Matchers.equalTo((Object)"CALL dbms.security.createUser('foo', '******')"));
        obfuscated = QueryObfuscation.obfuscateText((String)"CALL dbms.security.createUser('foo', $password)", params);
        MatcherAssert.assertThat(params, (Matcher)Matchers.equalTo(Set.of("password")));
        MatcherAssert.assertThat((Object)obfuscated, (Matcher)Matchers.equalTo((Object)"CALL dbms.security.createUser('foo', $password)"));
        obfuscated = QueryObfuscation.obfuscateText((String)"CALL dbms.security.createUser('foo', $password, false)", params);
        MatcherAssert.assertThat(params, (Matcher)Matchers.equalTo(Set.of("password")));
        MatcherAssert.assertThat((Object)obfuscated, (Matcher)Matchers.equalTo((Object)"CALL dbms.security.createUser('foo', $password, false)"));
    }
}

