/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.index.label.NodeLabelRange;

class NodeLabelRangeTest {
    NodeLabelRangeTest() {
    }

    @Test
    void shouldTransposeNodeIdsAndLabelIds() {
        long[][] labelsPerNode = new long[][]{{1L}, {1L, 3L}, {3L, 5L, 7L}, new long[0], {1L, 5L, 7L}, new long[0], new long[0], {1L, 2L, 3L, 4L}};
        NodeLabelRange range = new NodeLabelRange(0L, (long[][])labelsPerNode);
        Assertions.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L}, (long[])range.nodes());
        for (int i = 0; i < labelsPerNode.length; ++i) {
            Assertions.assertArrayEquals((long[])labelsPerNode[i], (long[])range.labels((long)i));
        }
    }

    @Test
    void shouldRebaseOnRangeId() {
        long[][] labelsPerNode = new long[][]{{1L}, {1L, 3L}, {3L, 5L, 7L}, new long[0], {1L, 5L, 7L}, new long[0], new long[0], {1L, 2L, 3L, 4L}};
        NodeLabelRange range = new NodeLabelRange(10L, (long[][])labelsPerNode);
        long baseNodeId = range.id() * (long)labelsPerNode.length;
        long[] expectedNodeIds = new long[labelsPerNode.length];
        for (int i = 0; i < expectedNodeIds.length; ++i) {
            expectedNodeIds[i] = baseNodeId + (long)i;
        }
        Assertions.assertArrayEquals((long[])expectedNodeIds, (long[])range.nodes());
    }
}

