/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class DatabasePageCacheTest {
    @Inject
    private TestDirectory testDirectory;
    private DatabasePageCache databasePageCache;
    private PageCache globalPageCache;
    private PagedFileAnswer pagedFileMapper;

    DatabasePageCacheTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.globalPageCache = (PageCache)Mockito.mock(PageCache.class);
        this.pagedFileMapper = new PagedFileAnswer();
        Mockito.when((Object)this.globalPageCache.map((File)ArgumentMatchers.any(File.class), (VersionContextSupplier)ArgumentMatchers.any(), ArgumentMatchers.eq((int)8192), new OpenOption[0])).then((Answer)this.pagedFileMapper);
        this.databasePageCache = new DatabasePageCache(this.globalPageCache, EmptyVersionContextSupplier.EMPTY);
    }

    @AfterEach
    void tearDown() {
        if (this.databasePageCache != null) {
            this.databasePageCache.close();
        }
    }

    @Test
    void mapDatabaseFile() throws IOException {
        File mapFile = this.testDirectory.createFile("mapFile", new String[0]);
        PagedFile pagedFile = this.databasePageCache.map(mapFile, EmptyVersionContextSupplier.EMPTY, 8192, new OpenOption[0]);
        Assertions.assertNotNull((Object)pagedFile);
        ((PageCache)Mockito.verify((Object)this.globalPageCache)).map(mapFile, EmptyVersionContextSupplier.EMPTY, 8192, new OpenOption[0]);
    }

    @Test
    void listExistingDatabaseMappings() throws IOException {
        File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
        File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
        PagedFile pagedFile = this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
        PagedFile pagedFile2 = this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
        List pagedFiles = this.databasePageCache.listExistingMappings();
        MatcherAssert.assertThat((Object)pagedFiles, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)pagedFiles, (Matcher)Matchers.hasItem((Object)pagedFile));
        MatcherAssert.assertThat((Object)pagedFiles, (Matcher)Matchers.hasItem((Object)pagedFile2));
    }

    @Test
    void doNotIncludeNotDatabaseFilesInMappingsList() throws IOException {
        try (DatabasePageCache anotherDatabaseCache = new DatabasePageCache(this.globalPageCache, EmptyVersionContextSupplier.EMPTY);){
            File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
            File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
            File mapFile3 = this.testDirectory.createFile("mapFile3", new String[0]);
            File mapFile4 = this.testDirectory.createFile("mapFile4", new String[0]);
            PagedFile pagedFile = this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
            PagedFile pagedFile2 = this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
            PagedFile pagedFile3 = anotherDatabaseCache.map(mapFile3, 8192, new OpenOption[0]);
            PagedFile pagedFile4 = anotherDatabaseCache.map(mapFile4, 8192, new OpenOption[0]);
            List pagedFiles = this.databasePageCache.listExistingMappings();
            MatcherAssert.assertThat((Object)pagedFiles, (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat((Object)pagedFiles, (Matcher)Matchers.hasItems((Object[])new PagedFile[]{pagedFile, pagedFile2}));
            List anotherPagedFiles = anotherDatabaseCache.listExistingMappings();
            MatcherAssert.assertThat((Object)anotherPagedFiles, (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat((Object)anotherPagedFiles, (Matcher)Matchers.hasItems((Object[])new PagedFile[]{pagedFile3, pagedFile4}));
        }
    }

    @Test
    void existingMappingRestrictedToDatabaseMappedFiles() throws IOException {
        try (DatabasePageCache anotherDatabaseCache = new DatabasePageCache(this.globalPageCache, EmptyVersionContextSupplier.EMPTY);){
            File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
            File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
            File mapFile3 = this.testDirectory.createFile("mapFile3", new String[0]);
            File mapFile4 = this.testDirectory.createFile("mapFile4", new String[0]);
            this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
            this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile3, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile4, 8192, new OpenOption[0]);
            Assertions.assertTrue((boolean)this.databasePageCache.getExistingMapping(mapFile1).isPresent());
            Assertions.assertTrue((boolean)this.databasePageCache.getExistingMapping(mapFile2).isPresent());
            Assertions.assertFalse((boolean)this.databasePageCache.getExistingMapping(mapFile3).isPresent());
            Assertions.assertFalse((boolean)this.databasePageCache.getExistingMapping(mapFile4).isPresent());
            Assertions.assertFalse((boolean)anotherDatabaseCache.getExistingMapping(mapFile1).isPresent());
            Assertions.assertFalse((boolean)anotherDatabaseCache.getExistingMapping(mapFile2).isPresent());
            Assertions.assertTrue((boolean)anotherDatabaseCache.getExistingMapping(mapFile3).isPresent());
            Assertions.assertTrue((boolean)anotherDatabaseCache.getExistingMapping(mapFile4).isPresent());
        }
    }

    @Test
    void throwOnMultipleCloseAttempts() {
        this.databasePageCache.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.databasePageCache.close());
        this.databasePageCache = null;
    }

    @Test
    void flushOnlyAffectsDatabaseRelatedFiles() throws IOException {
        try (DatabasePageCache anotherDatabaseCache = new DatabasePageCache(this.globalPageCache, EmptyVersionContextSupplier.EMPTY);){
            File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
            File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
            File mapFile3 = this.testDirectory.createFile("mapFile3", new String[0]);
            File mapFile4 = this.testDirectory.createFile("mapFile4", new String[0]);
            this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
            this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile3, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile4, 8192, new OpenOption[0]);
            this.databasePageCache.flushAndForce();
            List<PagedFile> pagedFiles = this.pagedFileMapper.getPagedFiles();
            PagedFile originalPagedFile1 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile1);
            PagedFile originalPagedFile2 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile2);
            PagedFile originalPagedFile3 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile3);
            PagedFile originalPagedFile4 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile4);
            ((PagedFile)Mockito.verify((Object)originalPagedFile1)).flushAndForce();
            ((PagedFile)Mockito.verify((Object)originalPagedFile2)).flushAndForce();
            ((PagedFile)Mockito.verify((Object)originalPagedFile3, (VerificationMode)Mockito.never())).flushAndForce();
            ((PagedFile)Mockito.verify((Object)originalPagedFile4, (VerificationMode)Mockito.never())).flushAndForce();
        }
    }

    @Test
    void flushWithLimiterOnlyAffectsDatabaseRelatedFiles() throws IOException {
        try (DatabasePageCache anotherDatabaseCache = new DatabasePageCache(this.globalPageCache, EmptyVersionContextSupplier.EMPTY);){
            File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
            File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
            File mapFile3 = this.testDirectory.createFile("mapFile3", new String[0]);
            File mapFile4 = this.testDirectory.createFile("mapFile4", new String[0]);
            this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
            this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile3, 8192, new OpenOption[0]);
            anotherDatabaseCache.map(mapFile4, 8192, new OpenOption[0]);
            this.databasePageCache.flushAndForce(IOLimiter.UNLIMITED);
            List<PagedFile> pagedFiles = this.pagedFileMapper.getPagedFiles();
            PagedFile originalPagedFile1 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile1);
            PagedFile originalPagedFile2 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile2);
            PagedFile originalPagedFile3 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile3);
            PagedFile originalPagedFile4 = DatabasePageCacheTest.findPagedFile(pagedFiles, mapFile4);
            ((PagedFile)Mockito.verify((Object)originalPagedFile1)).flushAndForce(IOLimiter.UNLIMITED);
            ((PagedFile)Mockito.verify((Object)originalPagedFile2)).flushAndForce(IOLimiter.UNLIMITED);
            ((PagedFile)Mockito.verify((Object)originalPagedFile3, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
            ((PagedFile)Mockito.verify((Object)originalPagedFile4, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
        }
    }

    @Test
    void closingFileCloseCacheMapping() throws IOException {
        File mapFile1 = this.testDirectory.createFile("mapFile1", new String[0]);
        File mapFile2 = this.testDirectory.createFile("mapFile2", new String[0]);
        PagedFile pagedFile1 = this.databasePageCache.map(mapFile1, 8192, new OpenOption[0]);
        PagedFile pagedFile2 = this.databasePageCache.map(mapFile2, 8192, new OpenOption[0]);
        Assertions.assertEquals((int)2, (int)this.databasePageCache.listExistingMappings().size());
        pagedFile1.close();
        Assertions.assertEquals((int)1, (int)this.databasePageCache.listExistingMappings().size());
        pagedFile2.close();
        Assertions.assertTrue((boolean)this.databasePageCache.listExistingMappings().isEmpty());
    }

    private static PagedFile findPagedFile(List<PagedFile> pagedFiles, File mapFile) {
        return pagedFiles.stream().filter(pagedFile -> pagedFile.file().equals(mapFile)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Mapped paged file '%s' not found", mapFile.getName())));
    }

    private static class PagedFileAnswer
    implements Answer<PagedFile> {
        private final List<PagedFile> pagedFiles = new ArrayList<PagedFile>();

        private PagedFileAnswer() {
        }

        public PagedFile answer(InvocationOnMock invocation) {
            PagedFile pagedFile = (PagedFile)Mockito.mock(PagedFile.class);
            Mockito.when((Object)pagedFile.file()).thenReturn((Object)((File)invocation.getArgument(0)));
            this.pagedFiles.add(pagedFile);
            return pagedFile;
        }

        List<PagedFile> getPagedFiles() {
            return this.pagedFiles;
        }
    }
}

